<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use App\Models\UserInvestment;
use App\Services\InvestmentService;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        // Schedule your commands here
        $schedule->command('trading:process-daily')->hourly();
        $schedule->command('investments:update')->hourly();
        $schedule->command('bots:process-daily')->hourly();
        $schedule->command('trades:process')->hourly();
        $schedule->command('investments:payout')->hourly();
        $schedule->command('staking:process')->hourly();
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}
