<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AdminLoginController extends Controller
{
    public function showadminLoginForm()
    {
        return view('auth.admin-login', ['title' => 'Admin Login'],); // Create this view
    }

    public function adminlogin(Request $request)
    {
        $request->validate([
            'login'    => 'required|string|regex:/^[^<>]*$/', // accepts email or username
            'password' => 'required|min:8|regex:/^[^<>]*$/',
        ]);

        $loginField = filter_var($request->login, FILTER_VALIDATE_EMAIL) ? 'email' : 'username';

        $credentials = [
            $loginField => $request->login,
            'password' => $request->password,
            'role' => 'admin', // only allow admin login
        ];

        if (Auth::attempt($credentials)) {
            return redirect()->route('admin.dashboard');
        }

        return back()->withErrors([
            'login' => 'Invalid credentials or not an admin',
        ]);
    }


    public function adminlogout()
    {
        Auth::logout();
        return redirect()->route('admin.login');
    }
}
