<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules\Password;

class PasswordController extends Controller
{
    /**
     * Update the user's password.
     */
    public function update(Request $request): RedirectResponse
    {
        $validated = $request->validateWithBag('updatePassword', [
            'current_password' => ['required', 'current_password'],
            'password' => ['required', Password::defaults(), 'confirmed'],
        ]);

        $request->user()->update([
            'password' => Hash::make($validated['password']),
        ]);

        // ✅ Log user activity (guaranteed call)
        if (function_exists('logUserActivity')) {
            logUserActivity('Password Update', 'Your Password was Updated.');
        } else {
            \Log::warning('⚠️ logUserActivity() not found — ensure it’s globally loaded or autoloaded.');
        }

        return back()->with('success', 'Password updated');
    }
}
