<?php

namespace App\Http\Controllers;

use App\Models\InvestmentPlan;
use Illuminate\Http\Request;

class InvestmentPlanController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function admininvestplanindex(Request $request)
    {
        $pageTitle = 'Investment Plans';

        $plans = InvestmentPlan::latest()->get();

        return view('admin/investment/plan', compact('pageTitle', 'plans'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function admininvestplanadd()
    {
        $pageTitle = 'Add Plans';

        return view('admin/investment/add_plan', compact('pageTitle'));
    }

    // Show all plans (for admin or frontend display)

    // Store a new investment plan
    public function adminplanstore(Request $request)
    {
        // dd($request->all());
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'min_amount' => 'required|numeric|min:0',
            'max_amount' => 'nullable|numeric|gte:min_amount',
            'interest_rate' => 'required|numeric|min:0',
            'duration' => 'required|string|max:255',
            'interest_type' => 'required|in:daily,weekly,monthly,end',
            'status' => 'required|in:Active,Inactive',
        ]);

        InvestmentPlan::create($validated);

        return redirect()->route('admin.invest.plan')->with('success', 'Plan Added Successfully');
    }


    public function admininvestplanedit(Request $request, $id)
    {
        $plan = InvestmentPlan::findorfail($id);

        $pageTitle = 'Update ' . $plan->name . ' Plan';

        return view('admin/investment/edit_plan', compact('pageTitle', 'plan'));
    }

    // Update an investment plan
    public function admininvestplanupdate(Request $request, $id)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'min_amount' => 'required|numeric|min:0',
            'max_amount' => 'nullable|numeric|gte:min_amount',
            'interest_rate' => 'required|numeric|min:0',
            'duration' => 'required|string|max:255',
            'interest_type' => 'required|in:daily,weekly,monthly,end',
            'status' => 'required|in:Active,Inactive',
        ]);

        $plan = InvestmentPlan::findorfail($id);

        $plan->update($validated);

        return redirect()->route('admin.invest.plan')->with('success', 'Investment plan updated successfully!');
    }

    // Delete a plan
    public function destroy(InvestmentPlan $plan)
    {
        $plan->delete();
        return redirect()->route('admin.plans.index')->with('success', 'Plan deleted successfully.');
    }
}
