<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;

class LoginAsUserController extends Controller
{
    public function adminstartloginasuser($id)
    {
        $user = User::findOrFail($id);

        // Store current admin ID so they can return
        session(['impersonator_id' => Auth::id()]);

        // Login as the user
        Auth::login($user);

        return redirect()->route('user.dashboard')
            ->with('success', 'You are now Logged in as this user.');
    }

    public function adminstoploginasuser()
    {
        // Check if impersonation session exists
        if (!session()->has('impersonator_id')) {
            abort(403, 'Not impersonating');
        }

        // Get stored admin ID
        $adminId = session('impersonator_id');

        // Remove the impersonation flag
        session()->forget('impersonator_id');

        // Logout the current (impersonated) user
        Auth::logout();

        // Destroy session completely
        session()->invalidate();
        session()->regenerateToken();

        // Log back in as the admin
        Auth::loginUsingId($adminId);

        return redirect()->route('admin.user.index')
            ->with('success', 'You have returned to your admin account.');
    }
}
