<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Intervention\Image\Encoders\JpegEncoder;
use Intervention\Image\Laravel\Facades\Image;
use App\Models\Support;

class SupportController extends Controller
{
    public function homecontactstore(Request $request)
    {
        // dd($request->all());

        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'title' => 'required|string|max:255',
            'message' => 'required|string|max:10000',
            'captcha' => ['required', function ($attribute, $value, $fail) use ($request) {
                $sessionCode = $request->session()->get('captcha_code');
                if (!$sessionCode || strtoupper(trim($value)) !== $sessionCode) {
                    $fail('Invalid captcha code.');
                }
            }],
        ]);

        $data = $request->only('name', 'email', 'title', 'message');

        Support::create($data);

        return redirect()->back()->with('message', 'Your message has been sent successfully!');
    }


    public function usersupportstore(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'title' => 'required|string|max:255',
            'message' => 'required|string|max:10000',
            'image' => 'nullable|image|mimes:jpg,jpeg,png,webp|max:2048',
        ]);

        $data = $request->only('name', 'email', 'title', 'message');

        if ($request->hasFile('image')) {
            $file = $request->file('image');

            // ✅ Generate a random, secure filename
            $randomStr = Str::random(30);
            $filename = $randomStr . '.jpg';

            // ✅ Define safe storage path (inside storage/app/public/support)
            $storagePath = storage_path('app/public/support/');

            // ✅ Create folder if missing
            if (!file_exists($storagePath)) {
                mkdir($storagePath, 0755, true);
            }

            // ✅ Read, sanitize, re-encode to JPG (removes malicious content)
            $image = Image::read($file->getRealPath())
                ->orient()
                ->encode(new JpegEncoder(quality: 85));

            // ✅ Save to storage/app/public/support
            $image->save($storagePath . $filename);

            // ✅ Store path for DB reference
            $data['image'] = 'support/' . $filename;
        }

        Support::create($data);

        return redirect()->back()->with('message', 'Your support message has been sent successfully!');
    }
}
