<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use App\Models\TransferTransaction;

class TransferController extends Controller
{
    public function showusertransfer()
    {
        $pageTitle = 'Internal Transfer';
        return view('user.internal_transfer', compact('pageTitle'));
    }

    public function storeusertransfer(Request $request)
    {
        $user = Auth::user();

        // ✅ Validate request
        $request->validate([
            'recipient' => 'required|string',
            'amount' => 'required|numeric|min:1',
            'note' => 'nullable|string|max:255',
        ]);

        // ✅ Find recipient by email or username
        $recipient = User::where('email', $request->recipient)
            ->orWhere('username', $request->recipient)
            ->first();

        if (!$recipient) {
            return back()->with('error', 'Recipient not found.');
        }

        if ($recipient->id === $user->id) {
            return back()->with('error', 'You cannot transfer to yourself.');
        }

        // ✅ Check balance
        if ($user->balance < $request->amount) {
            return back()->with('error', 'Insufficient balance.');
        }

        // ✅ Process transfer
        $reference = strtoupper(Str::random(10));

        // Deduct from sender
        $user->decrement('balance', $request->amount);

        // Credit receiver
        $recipient->increment('balance', $request->amount);

        // Log transaction
        TransferTransaction::create([
            'sender_id' => $user->id,
            'receiver_id' => $recipient->id,
            'amount' => $request->amount,
            'reference' => $reference,
            'note' => $request->note,
            'status' => 'successful',
        ]);

        return redirect()->route('user.internal_transfer')->with('success', 'Transfer successful!');
    }
}
