<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use QrCode;
use Illuminate\Support\Facades\Auth;
use Google2FA;

class TwoFactorController extends Controller
{
    // public function enable2FA()
    // {
    //     $user = Auth::user();

    //     $secret = Google2FA::generateSecretKey();

    //     $qrcode = QrCode::size(220)->generate(
    //         Google2FA::getQRCodeUrl(
    //             config('app.name'),
    //             $user->email,
    //             $secret
    //         )
    //     );

    //     return view('user.2fa.setup', [
    //         'secret'  => $secret,
    //         'qrcode'  => $qrcode,
    //     ]);
    // }

    public function store2FA(Request $request)
    {
        $user = Auth::user();

        $user->google2fa_secret = $request->secret;
        $user->is_2fa_enabled = true;
        $user->save();

        return redirect()->route('user.dashboard')
            ->with('success', 'Two-factor authentication enabled.');
    }

    public function verify2FA(Request $request)
    {
        $user = Auth::user();
        $valid = Google2FA::verifyKey($user->google2fa_secret, $request->code);

        if ($valid) {
            session(['2fa_verified' => true]);
            return redirect()->route('user.dashboard');
        }

        return back()->withErrors(['code' => 'Invalid authentication code']);
    }

    public function disable2fa()
    {
        $user = Auth::user();

        // Remove secret + disable flag
        $user->google2fa_secret = null;
        $user->is_2fa_enabled = false;
        $user->save();

        // Clear session verification
        session()->forget('2fa_verified');

        return redirect()->route('user.dashboard')
            ->with('success', 'Two-factor authentication has been disabled.');
    }

    public function showVerifyForm()
    {
        if (!session('2fa:user:id')) {
            return redirect()->route('login');
        }

        return view('auth.2fa_verify');
    }

    public function login2faverify(Request $request)
    {
        $request->validate(['code' => 'required']);

        $user = User::find(session('2fa:user:id'));

        if (!$user) {
            return redirect()->route('login');
        }

        $google2fa = app('pragmarx.google2fa');

        $valid = $google2fa->verifyKey($user->google2fa_secret, $request->code);

        if ($valid) {
            Auth::login($user);
            session()->forget('2fa:user:id');
            return redirect()->route('user.dashboard');
        }

        return back()->withErrors(['code' => 'Invalid authentication code']);
    }
}
