<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\RedirectResponse;
use Symfony\Component\HttpFoundation\Response;

class CheckUserStatus
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next): Response|RedirectResponse
    {
        // Prevent redirect loop on login route
        if ($request->routeIs('login')) {
            return $next($request);
        }

        // If user is logged in but inactive
        if (Auth::check() && Auth::user()->status === 'Inactive') {
            $email = Auth::User()->email;
            Auth::logout();
            return redirect()->route('login')->with([
                'error' => 'Your account is inactive. Please contact support.',
                'email' => $email, // optional: to prefill the login email field
            ]);
        }

        return $next($request);
    }
}
