<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Session;

class PreventAccessAfterSubmission
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Check if the user has submitted the form (you can store this in the session or database)
        if (Session::has('form_submitted') && Session::get('form_submitted') === true) {
            // Redirect to another page (home, dashboard, etc.) if the form has already been submitted
            return redirect('user/dashboard')->with('message', 'Your account is already set up.');
        }

        // If not, allow the request to proceed
        return $next($request);
    }
}
