<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class AdminCopyTradeStartedMail extends Mailable
{
    use Queueable, SerializesModels;

    public $user;
    public $expert;
    public $trade;

    public function __construct($user, $expert, $trade)
    {
        $this->user = $user;
        $this->expert = $expert;
        $this->trade = $trade;
    }

    public function build()
    {
        return $this->subject('New Copy Trade Started')
            ->view('emails.copytrade.admin_started');
    }
}
