<?php

namespace App\Mail;

use App\Models\LiveTrade;
use App\Models\WebsiteSetting;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class AdminLiveTradeAlertMail extends Mailable
{
    use Queueable, SerializesModels;

    public $trade;
    public $websiteSettings;

    public function __construct(LiveTrade $trade)
    {
        $this->trade = $trade;
        $this->websiteSettings = WebsiteSetting::first();
    }

    public function build()
    {
        return $this->subject('New Live Trade Alert - ' . $this->websiteSettings->site_name)
            ->view('emails.admin_live_trade_alert');
    }
}
