<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class AdminNewStakingMail extends Mailable
{
    use Queueable, SerializesModels;

    public $user;
    public $plan;
    public $staking;

    public function __construct($user, $plan, $staking)
    {
        $this->user = $user;
        $this->plan = $plan;
        $this->staking = $staking;
    }

    public function build()
    {
        return $this->subject('New Staking Created')
            ->view('emails.admin.new_staking');
    }
}
