<?php

namespace App\Mail;

use App\Models\Investment;
use App\Models\WebsiteSetting;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class InvestmentStartedMail extends Mailable
{
    use Queueable, SerializesModels;

    public $investment;
    public $websiteSettings;

    public function __construct(Investment $investment)
    {
        $this->investment = $investment;
        $this->websiteSettings = WebsiteSetting::first();
    }

    public function build()
    {
        return $this->subject('Your Investment Has Started - ' . $this->websiteSettings->site_name)
            ->view('emails.investment_started');
    }
}
