<?php

namespace App\Mail;

use App\Models\KycVerification;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class KycApprovedMail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public $kyc;

    public function __construct(KycVerification $kyc)
    {
        $this->kyc = $kyc;
    }

    public function build()
    {
        return $this->subject('KYC Verification Approved')
            ->view('emails.kyc.approved')
            ->with([
                'name' => $this->kyc->firstname . ' ' . $this->kyc->lastname,
                'date' => now()->format('M d, Y h:i A'),
            ]);
    }
}
