<?php

namespace App\Mail;

use App\Models\KycVerification;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class KycRejectedMail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public $kyc;

    public function __construct(KycVerification $kyc)
    {
        $this->kyc = $kyc;
    }

    public function build()
    {
        return $this->subject('KYC Verification Rejected')
            ->view('emails.kyc.rejected')
            ->with([
                'name' => $this->kyc->firstname . ' ' . $this->kyc->lastname,
                'idType' => $this->kyc->id_type,
                'date' => now()->format('M d, Y h:i A'),
            ]);
    }
}
