<?php

namespace App\Mail;

use App\Models\KycVerification;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class KycSubmittedMail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public $kyc;

    public function __construct(KycVerification $kyc)
    {
        $this->kyc = $kyc;
    }

    public function build()
    {
        return $this->subject('KYC Verification Submitted - Pending Review')
            ->view('emails.kyc.user_submitted')
            ->with([
                'name' => $this->kyc->firstname . ' ' . $this->kyc->lastname,
                'idType' => $this->kyc->id_type,
                'date' => $this->kyc->created_at->format('M d, Y h:i A'),
            ]);
    }
}
