<?php

namespace App\Mail;

use App\Models\UserBotTrade;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class NewBotTradeAlertMail extends Mailable
{
    use Queueable, SerializesModels;

    public $trade;

    public function __construct(UserBotTrade $trade)
    {
        $this->trade = $trade;
    }

    public function build()
    {
        return $this->subject('🚀 New AI Bot Trade Started')
            ->view('emails.admin.new_bot_trade_alert')
            ->with(['trade' => $this->trade]);
    }
}
