<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class RealEstateInvestmentAdminMail extends Mailable
{
    use Queueable, SerializesModels;

    public $user;
    public $estate;
    public $investment;

    public function __construct($user, $estate, $investment)
    {
        $this->user = $user;
        $this->estate = $estate;
        $this->investment = $investment;
    }

    public function build()
    {
        return $this->subject('New Real Estate Investment')
            ->view('emails.realestate.admin');
    }
}
