<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class UserCopyTradeStoppedMail extends Mailable
{
    use Queueable, SerializesModels;

    public $user, $trade, $finalAmount;

    public function __construct($user, $trade, $finalAmount)
    {
        $this->user = $user;
        $this->trade = $trade;
        $this->finalAmount = $finalAmount;
    }

    public function build()
    {
        return $this->subject('Copy Trade Stopped')
            ->view('emails.copytrade.user_stopped');
    }
}
