<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class UserStakingCompletedMail extends Mailable
{
    use Queueable, SerializesModels;

    public $user;
    public $stake;
    public $totalReturn;

    public function __construct($user, $stake, $totalReturn)
    {
        $this->user = $user;
        $this->stake = $stake;
        $this->totalReturn = $totalReturn;
    }

    public function build()
    {
        return $this->subject('Staking Completed')
            ->view('emails.user.staking_completed');
    }
}
