<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class UserStakingStartedMail extends Mailable
{
    use Queueable, SerializesModels;

    public $user;
    public $plan;
    public $staking;

    public function __construct($user, $plan, $staking)
    {
        $this->user = $user;
        $this->plan = $plan;
        $this->staking = $staking;
    }

    public function build()
    {
        return $this->subject('Your Staking Has Started')
            ->view('emails.user.staking_started');
    }
}
