<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InvestmentLog extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id',
        'investment_id',
        'amount',
        'type',
        'note',
    ];


    public function investmentlog()
    {
        return $this->belongsTo(Investment::class, 'investment_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function investment()
    {
        return $this->belongsTo(Investment::class, 'investment_id');
    }
}
