<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RealEstateInvestment extends Model
{
    protected $fillable = [
        'user_id',
        'real_estate_id',
        'amount',
        'duration_days',
        'start_date',
        'end_date',
        'roi_percent',
        'profit',
        'total_return',
        'payout_date',
        'is_paid',
        'status'
    ];

    protected $casts = [
        'start_date' => 'datetime',
        'end_date' => 'datetime',
        'payout_date' => 'datetime',
    ];

    public function estate()
    {
        return $this->belongsTo(RealEstate::class, 'real_estate_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
