<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Signal extends Model
{
    protected $fillable = [
        'title',
        'description',
        'pair',
        'direction',
        'entry_price',
        'take_profit',
        'stop_loss',
        'price',
        'strength',
        'is_active',
        'is_vip',
        'expires_at'
    ];

    public function purchases()
    {
        return $this->hasMany(SignalPurchase::class);
    }

    public function ratings()
    {
        return $this->hasMany(SignalRating::class);
    }

    public function avgRating()
    {
        return $this->ratings()->avg('rating');
    }
}
