<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Staking extends Model
{
    use HasFactory;

    protected $fillable = ['user_id', 'staking_plan_id', 'cryptocurrencies_id', 'amount', 'interest_rate', 'duration', 'status', 'start_date', 'end_date'];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function cryptos()
    {
        return $this->belongsTo(Cryptocurrency::class, 'cryptocurrencies_id');
    }

    public function stakingPlan()
    {
        return $this->belongsTo(StakingPlan::class, 'staking_plan_id');
    }

    protected $casts = [
        'start_date' => 'datetime',
        'end_date' => 'datetime',
        'completed_at' => 'datetime',
    ];
}
