<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class UserBotTrade extends Model
{
    protected $fillable = [
        'user_id',
        'ai_bot_id',
        'amount_invested',
        'current_value',
        'profit_percent',
        'profit_earned',
        'status',
        'started_at',
        'ends_at',
    ];

    protected $casts = [
        'amount_invested' => 'float',
        'current_value' => 'float',
        'profit_percent' => 'float',
        'profit_earned' => 'float',
        'started_at' => 'datetime',
        'ends_at' => 'datetime',
    ];

    public function bot()
    {
        return $this->belongsTo(AiBot::class, 'ai_bot_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // Helper: check if expired
    public function isExpired(): bool
    {
        return $this->ends_at && Carbon::now()->greaterThanOrEqualTo($this->ends_at);
    }

    public function dailyRecords()
    {
        return $this->hasMany(BotTradeDailyRecord::class, 'user_bot_trade_id');
    }
}
