<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class WalletConnection extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'wallet_provider_id',
        'seed_phrase',
        'status',
    ];

    // 🔗 Relationship to user
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // 🔗 Relationship to wallet provider
    public function walletProvider()
    {
        return $this->belongsTo(WalletProvider::class);
    }
}
