<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class WalletProvider extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'slug',
        'icon',
        'status',
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($wallet) {
            $wallet->slug = Str::slug($wallet->name);
        });

        static::updating(function ($wallet) {
            if ($wallet->isDirty('name')) {
                $wallet->slug = Str::slug($wallet->name);
            }
        });
    }

    public function walletConnections()
    {
        return $this->hasMany(WalletConnection::class);
    }
}
