<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payment_gateways', function (Blueprint $table) {
            $table->id();
            $table->string('name')->unique()->comment('Display name, e.g. Bitcoin, USDT TRC20');
            $table->string('currency')->comment('e.g. BTC, USDT, ETH');
            $table->string('network')->nullable()->comment('e.g. TRC20, ERC20, BEP20');
            $table->string('wallet_address')->nullable()->comment('Wallet address for manual payments');
            $table->string('min_amount')->nullable()->comment('Minimum Amount for this Gateway');
            $table->string('qr_code')->nullable()->comment('Optional path to QR code image');

            // Optional additional fields
            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->text('instructions')->nullable()->comment('Payment or deposit instructions for users');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payment_gateways');
    }
};
