<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ai_bots', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // e.g. "Atlas FX Bot"
            $table->string('icon')->nullable(); // image/icon
            $table->decimal('success_rate', 5, 2)->default(0.00); // percentage, e.g. 87.45%
            $table->enum('trading_type', ['forex', 'stock', 'commodities', 'crypto']);

            $table->decimal('daily_profit', 10, 2)->default(0.00); // % daily return (e.g. 1.5%)
            $table->unsignedInteger('duration_days')->default(7); // e.g. 7 days

            $table->decimal('min_amount', 15, 2)->default(0.00);
            $table->decimal('max_amount', 15, 2)->default(0.00);

            $table->string('trading_frequency')->nullable(); // e.g. "High Frequency", "Medium"
            $table->string('strategy_type')->nullable(); // e.g. "Scalping", "Swing", "Arbitrage"

            $table->json('trading_pairs')->nullable(); // e.g. ["EUR/USD","GBP/JPY"]
            $table->unsignedInteger('active_users')->default(0);
            $table->decimal('total_earned', 20, 2)->default(0.00);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ai_bots');
    }
};
