<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bot_trade_daily_records', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_bot_trade_id')->constrained()->cascadeOnDelete();
            $table->decimal('percent', 8, 4); // signed percent for that day (e.g. 1.234 or -0.75)
            $table->decimal('profit', 18, 6); // signed profit amount added/subtracted
            $table->date('recorded_at'); // the date this profit applies to
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bot_trade_daily_records');
    }
};
