<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('deposits', function (Blueprint $table) {
            // Remove old payment_method if it exists
            if (Schema::hasColumn('deposits', 'payment_method')) {
                $table->dropColumn('payment_method');
            }

            // Add new foreign key for payment_gateway_id
            $table->unsignedBigInteger('payment_gateway_id')->nullable()->after('user_id');
            $table->foreign('payment_gateway_id')->references('id')->on('payment_gateways')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::table('deposits', function (Blueprint $table) {
            $table->dropForeign(['payment_gateway_id']);
            $table->dropColumn('payment_gateway_id');
            $table->string('payment_method')->nullable(); // revert if needed
        });
    }
};
