<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_copy_trades', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->foreignId('trade_expert_id')->constrained()->cascadeOnDelete();

            $table->decimal('amount', 15, 2);
            $table->decimal('current_value', 15, 2)->default(0);
            $table->decimal('profit_loss', 15, 2)->default(0);
            $table->decimal('roi_percentage', 8, 2)->default(0);
            $table->enum('status', ['active', 'stopped'])->default('active');

            // Optional advanced metrics
            $table->unsignedInteger('days_running')->default(0);
            $table->decimal('auto_adjustment_factor', 8, 4)->default(1.0);
            $table->timestamp('started_at')->nullable();
            $table->timestamp('stopped_at')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('user_copy_trades');
    }
};
