<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('wallet_providers', function (Blueprint $table) {
            $table->id();
            $table->string('name')->unique(); // e.g., "Trust Wallet", "MetaMask"
            $table->string('slug')->unique(); // e.g., "trust-wallet", "metamask"
            $table->string('icon')->nullable(); // store image filename or full URL
            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('wallet_providers');
    }
};
