<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('loan_types', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // e.g. "Mortgage Loan", "Auto Loan"
            $table->text('description')->nullable();
            $table->integer('min_duration')->default(6);
            $table->integer('max_duration')->default(60);
            $table->decimal('min_amount', 15, 2);
            $table->decimal('max_amount', 15, 2)->default(0);
            $table->decimal('interest_rate', 5, 2);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('loan_types');
    }
};
