<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('loans', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('loan_type_id')->constrained('loan_types')->onDelete('cascade');
            $table->decimal('amount', 15, 2);
            $table->integer('duration'); // in months
            $table->decimal('interest_rate', 5, 2);
            $table->decimal('total_payable', 15, 2);
            $table->decimal('monthly_payment', 15, 2);
            $table->decimal('monthly_income', 15, 2);
            $table->string('status')->default('pending'); // pending, approved, rejected, completed
            $table->text('reason')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('loans');
    }
};
