<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('signal_purchases', function (Blueprint $table) {
            $table->foreignId('payment_gateway_id')
                ->nullable()
                ->after('signal_id')
                ->constrained('payment_gateways')
                ->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::table('signal_purchases', function (Blueprint $table) {
            $table->dropForeign(['payment_gateway_id']);
            $table->dropColumn('payment_gateway_id');
        });
    }
};
