<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('real_estate_investments', function (Blueprint $table) {
            $table->date('start_date')->nullable()->after('duration_days');
            $table->date('end_date')->nullable()->after('start_date');
        });
    }

    public function down(): void
    {
        Schema::table('real_estate_investments', function (Blueprint $table) {
            $table->dropColumn(['start_date', 'end_date']);
        });
    }
};
