<?php

// database/seeders/TradeExpertSeeder.php
namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\TradeExpert;

class TradeExpertSeeder extends Seeder
{
    public function run(): void
    {
        $experts = [
            ['name' => 'Andrew Tate', 'title' => 'Forex Mentor'],
            ['name' => 'Warren Buffett', 'title' => 'Value Investor'],
            ['name' => 'Elon Musk', 'title' => 'Crypto Trader'],
            ['name' => 'Ray Dalio', 'title' => 'Hedge Fund Manager'],
            ['name' => 'Cathy Wood', 'title' => 'Tech Growth Expert'],
            ['name' => 'Peter Lynch', 'title' => 'Long-Term Investor'],
            ['name' => 'George Soros', 'title' => 'Macro Trader'],
            ['name' => 'Paul Tudor Jones', 'title' => 'Commodity Specialist'],
            ['name' => 'Linda Raschke', 'title' => 'Options Trader'],
            ['name' => 'Mark Minervini', 'title' => 'Momentum Expert'],
            ['name' => 'Tim Sykes', 'title' => 'Penny Stock Guru'],
            ['name' => 'Michael Burry', 'title' => 'Short Seller'],
            ['name' => 'Naval Ravikant', 'title' => 'Angel Investor'],
            ['name' => 'Jim Simons', 'title' => 'Quant Trader'],
            ['name' => 'Anthony Pompliano', 'title' => 'Crypto Analyst'],
        ];

        foreach ($experts as $data) {
            TradeExpert::create(array_merge($data, [
                'image' => 'experts/default.jpg',
                'rating' => rand(1, 5),
                'followers' => rand(1000, 50000),
                'win_rate' => rand(60, 98),
                'total_return' => rand(10, 200),
                'total_trades' => rand(50, 2000),
                'min_amount' => rand(50, 500),
                'status' => 'active',
                'description' => fake()->paragraph(),
            ]));
        }
    }
}
