<x-admin :title="$pageTitle">

    <div class="mx-auto max-w-(--breakpoint-2xl) p-4 pb-20 md:p-6 md:pb-6">
        <!-- Breadcrumb Start -->
        <div x-data="{ pageName: `Ai Bots` }">
            <div class="flex flex-wrap items-center justify-between gap-3 pb-6">
                <h2 class="text-xl font-semibold text-gray-800 dark:text-white/90" x-text="pageName"></h2>
                <nav>
                    <ol class="flex items-center gap-1.5">
                        <li>
                            <a class="inline-flex items-center gap-1.5 text-sm text-gray-500 dark:text-gray-400"
                                href="index.html">
                                Home
                                <svg class="stroke-current" width="17" height="16" viewBox="0 0 17 16"
                                    fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M6.0765 12.667L10.2432 8.50033L6.0765 4.33366" stroke=""
                                        stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </a>
                        </li>
                        <li class="text-sm text-gray-800 dark:text-white/90" x-text="pageName"></li>
                    </ol>
                </nav>
            </div>
        </div>
        <!-- Breadcrumb End -->

        <div class="space-y-5 sm:space-y-6">
            <div class="rounded-2xl border border-gray-200 bg-white dark:border-gray-800 dark:bg-white/[0.03]">
                <div class="flex flex-col justify-between gap-5 px-6 py-5 sm:flex-row sm:items-start">
                    <div>
                        <h3 class="text-base font-medium text-gray-800 dark:text-white/90">
                            All Ai Bots
                        </h3>
                    </div>
                    <div>
                        <a href="{{ url('admin/aibot/create') }}"
                            class="shadow-theme-xs flex w-full justify-center gap-2 rounded-lg border border-gray-300 bg-white px-4 py-3 text-sm font-medium text-gray-700 hover:bg-gray-50 hover:text-gray-800 dark:border-gray-700 dark:bg-gray-800 dark:text-gray-400 dark:hover:bg-white/[0.03] dark:hover:text-gray-200">
                            <svg xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 21 20"
                                fill="none">
                                <path d="M5.5 10.0002H15.5006M10.5002 5V15.0006" stroke="currentColor"
                                    stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                            Add New Bot
                        </a>
                    </div>
                </div>
                <div class="border-t border-gray-100 p-4 sm:p-6 dark:border-gray-800">
                    <!-- Pricing Table Two -->
                    <div class="gird-cols-1 grid gap-5 sm:grid-cols-2 xl:grid-cols-3 xl:gap-6">
                        @foreach ($bots as $item)
                            <div
                                class="rounded-2xl border-2 border-brand-500 bg-white p-6 dark:border-brand-500 dark:bg-white/[0.03] xl:p-8">
                                <div class="-mb-4 flex items-start justify-between">
                                    <span class="block text-theme-xl font-semibold text-gray-800 dark:text-white/90">
                                        {{ $item->name }}
                                    </span>

                                    <span
                                        class="flex h-[56px] w-[56px] items-center justify-center rounded-[10.5px] bg-brand-50 text-brand-500">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32"
                                            viewBox="0 0 32 32">
                                            <g fill="none">
                                                <path fill="#f8312f"
                                                    d="M5 3.5a1.5 1.5 0 0 1-1 1.415V12l2.16 5.487L4 23c-1.1 0-2-.9-2-1.998v-7.004a2 2 0 0 1 1-1.728V4.915A1.5 1.5 0 1 1 5 3.5m25.05.05c0 .681-.44 1.26-1.05 1.468V12.2c.597.347 1 .994 1 1.73v7.01c0 1.1-.9 2-2 2l-2.94-5.68L28 11.93V5.018a1.55 1.55 0 1 1 2.05-1.468" />
                                                <path fill="#ffb02e"
                                                    d="M11 4.5A1.5 1.5 0 0 1 12.5 3h7a1.5 1.5 0 0 1 .43 2.938c-.277.082-.57.104-.847.186l-3.053.904l-3.12-.908c-.272-.08-.56-.1-.832-.18A1.5 1.5 0 0 1 11 4.5" />
                                                <path fill="#cdc4d6"
                                                    d="M22.05 30H9.95C6.66 30 4 27.34 4 24.05V12.03C4 8.7 6.7 6 10.03 6h11.95C25.3 6 28 8.7 28 12.03v12.03c0 3.28-2.66 5.94-5.95 5.94" />
                                                <path fill="#212121"
                                                    d="M9.247 18.5h13.506c2.33 0 4.247-1.919 4.247-4.25A4.257 4.257 0 0 0 22.753 10H9.247A4.257 4.257 0 0 0 5 14.25a4.257 4.257 0 0 0 4.247 4.25m4.225 7.5h5.056C19.34 26 20 25.326 20 24.5s-.66-1.5-1.472-1.5h-5.056C12.66 23 12 23.674 12 24.5s.66 1.5 1.472 1.5" />
                                                <path fill="#00a6ed"
                                                    d="M10.25 12C9.56 12 9 12.56 9 13.25v2.5a1.25 1.25 0 1 0 2.5 0v-2.5c0-.69-.56-1.25-1.25-1.25m11.5 0c-.69 0-1.25.56-1.25 1.25v2.5a1.25 1.25 0 1 0 2.5 0v-2.5c0-.69-.56-1.25-1.25-1.25" />
                                            </g>
                                        </svg>
                                    </span>
                                </div>

                                <div class="flex items-end">
                                    <h2 class="text-title-sm font-bold text-gray-800 dark:text-white/90">
                                        ${{ $item->min_amount }} - ${{ $item->max_amount }}
                                    </h2>

                                    <span class="mb-1 inline-block text-sm text-gray-500 dark:text-gray-400">
                                        / {{ $item->duration_days }} Days
                                    </span>
                                </div>

                                <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">
                                    {{ $item->description }}
                                </p>

                                <div class="my-6 h-px w-full bg-white/20"></div>

                                <div class="mb-8 space-y-3">
                                    <p class="flex items-center gap-3 text-sm text-gray-700 dark:text-gray-400">
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path d="M13.4017 4.35986L6.12166 11.6399L2.59833 8.11657" stroke="#12B76A"
                                                stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                        Success Rate: {{ $item->success_rate }}
                                    </p>

                                    <p class="flex items-center gap-3 text-sm text-gray-700 dark:text-gray-400">
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path d="M13.4017 4.35986L6.12166 11.6399L2.59833 8.11657" stroke="#12B76A"
                                                stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                        Trading Type: {{ $item->trading_type }}
                                    </p>

                                    <p class="flex items-center gap-3 text-sm text-gray-700 dark:text-gray-400">
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path d="M13.4017 4.35986L6.12166 11.6399L2.59833 8.11657" stroke="#12B76A"
                                                stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                        Daily Profit: {{ $item->daily_profit }}
                                    </p>

                                    <p class="flex items-center gap-3 text-sm text-gray-700 dark:text-gray-400">
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path d="M13.4017 4.35986L6.12166 11.6399L2.59833 8.11657" stroke="#12B76A"
                                                stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                        Duration: {{ $item->duration_days }} Days
                                    </p>

                                    <p class="flex items-center gap-3 text-sm text-gray-700 dark:text-gray-400">
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path d="M13.4017 4.35986L6.12166 11.6399L2.59833 8.11657" stroke="#12B76A"
                                                stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                        Minimum Amount: {{ $item->min_amount }}
                                    </p>

                                    <p class="flex items-center gap-3 text-sm text-gray-700 dark:text-gray-400">
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path d="M13.4017 4.35986L6.12166 11.6399L2.59833 8.11657" stroke="#12B76A"
                                                stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                        Maximum Amount: {{ $item->max_amount }}
                                    </p>
                                </div>

                                <a href="{{ url('admin/aibot/edit/' . $item->id) }}"
                                    class="flex w-full items-center justify-center rounded-lg bg-brand-500 p-3.5 text-sm font-medium text-white shadow-theme-xs hover:bg-brand-600">
                                    Manage This Bot
                                </a>
                            </div>
                        @endforeach
                    </div>
                    <!-- Pricing Table Two -->
                </div>
            </div>
        </div>
    </div>

</x-admin>
