<x-admin :title="$pageTitle">

    <div class="mx-auto max-w-(--breakpoint-2xl) p-4 pb-20 md:p-6 md:pb-6">
        <!-- Breadcrumb Start -->
        <div x-data="{ pageName: `{{ $pageTitle }}' }">
            <div class="flex flex-wrap items-center justify-between gap-3 pb-6">
                <h2 class="text-xl font-semibold text-gray-800 dark:text-white/90" x-text="pageName"></h2>
                <nav>
                    <ol class="flex items-center gap-1.5">
                        <li>
                            <a class="inline-flex items-center gap-1.5 text-sm text-gray-500 dark:text-gray-400"
                                href="index.html">
                                Home
                                <svg class="stroke-current" width="17" height="16" viewBox="0 0 17 16" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path d="M6.0765 12.667L10.2432 8.50033L6.0765 4.33366" stroke="" stroke-width="1.2"
                                        stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </a>
                        </li>
                        <li class="text-sm text-gray-800 dark:text-white/90" x-text="pageName"></li>
                    </ol>
                </nav>
            </div>
        </div>
        <!-- Breadcrumb End -->

        <!-- Content Start -->
        <form action="{{ url('admin/smtp_settings') }}" method="POST">
            @csrf
            @method('PUT')
            <div class="space-y-6">
                <div class="rounded-2xl border border-gray-200 bg-white dark:border-gray-800 dark:bg-white/[0.03]">
                    <div class="border-b border-gray-200 px-6 py-4 dark:border-gray-800">
                        <h2 class="text-lg font-medium text-gray-800 dark:text-white">
                            Email SMTP Setup
                        </h2>
                    </div>
                    <div class="p-4 sm:p-6 dark:border-gray-800">
                        <div class="grid grid-cols-1 gap-5 md:grid-cols-2">
                            <div>
                                <label for="product-name"
                                    class="mb-1.5 block text-sm font-medium text-gray-700 dark:text-gray-400">Mail
                                    Mailer</label>
                                <input type="text" name="MAIL_MAILER" readonly
                                    class="dark:bg-dark-900 shadow-theme-xs focus:border-brand-300 focus:ring-brand-500/10 dark:focus:border-brand-800 h-11 w-full rounded-lg border border-gray-300 bg-transparent px-4 py-2.5 text-sm text-gray-800 placeholder:text-gray-400 focus:ring-3 focus:outline-hidden dark:border-gray-700 dark:bg-gray-900 dark:text-white/90 dark:placeholder:text-white/30"
                                    value="{{ old('MAIL_MAILER', $smtpSettings['MAIL_MAILER']) }}" />
                                <x-input-error :messages="$errors->get('MAIL_MAILER')" class="mt-2" />
                            </div>

                            <div>
                                <label for="product-name"
                                    class="mb-1.5 block text-sm font-medium text-gray-700 dark:text-gray-400">Mail
                                    Host</label>
                                <input type="text" name="MAIL_HOST"
                                    class="dark:bg-dark-900 shadow-theme-xs focus:border-brand-300 focus:ring-brand-500/10 dark:focus:border-brand-800 h-11 w-full rounded-lg border border-gray-300 bg-transparent px-4 py-2.5 text-sm text-gray-800 placeholder:text-gray-400 focus:ring-3 focus:outline-hidden dark:border-gray-700 dark:bg-gray-900 dark:text-white/90 dark:placeholder:text-white/30"
                                    value="{{ old('MAIL_HOST', $smtpSettings['MAIL_HOST']) }}" />
                                <x-input-error :messages="$errors->get('MAIL_HOST')" class="mt-2" />
                            </div>

                            <div>
                                <label for="product-name"
                                    class="mb-1.5 block text-sm font-medium text-gray-700 dark:text-gray-400">Mail
                                    Port</label>
                                <input type="text" name="MAIL_PORT"
                                    class="dark:bg-dark-900 shadow-theme-xs focus:border-brand-300 focus:ring-brand-500/10 dark:focus:border-brand-800 h-11 w-full rounded-lg border border-gray-300 bg-transparent px-4 py-2.5 text-sm text-gray-800 placeholder:text-gray-400 focus:ring-3 focus:outline-hidden dark:border-gray-700 dark:bg-gray-900 dark:text-white/90 dark:placeholder:text-white/30"
                                    value="{{ old('MAIL_PORT', $smtpSettings['MAIL_PORT']) }}" />
                                <x-input-error :messages="$errors->get('MAIL_PORT')" class="mt-2" />
                            </div>

                            <div>
                                <label for="product-name"
                                    class="mb-1.5 block text-sm font-medium text-gray-700 dark:text-gray-400">Mail
                                    Username</label>
                                <input type="text" name="MAIL_USERNAME"
                                    class="dark:bg-dark-900 shadow-theme-xs focus:border-brand-300 focus:ring-brand-500/10 dark:focus:border-brand-800 h-11 w-full rounded-lg border border-gray-300 bg-transparent px-4 py-2.5 text-sm text-gray-800 placeholder:text-gray-400 focus:ring-3 focus:outline-hidden dark:border-gray-700 dark:bg-gray-900 dark:text-white/90 dark:placeholder:text-white/30"
                                    value="{{ old('MAIL_USERNAME', $smtpSettings['MAIL_USERNAME']) }}" />
                                <x-input-error :messages="$errors->get('MAIL_USERNAME')" class="mt-2" />
                            </div>

                            <div>
                                <label for="product-name"
                                    class="mb-1.5 block text-sm font-medium text-gray-700 dark:text-gray-400">Mail
                                    Password</label>
                                <input type="text" name="MAIL_PASSWORD"
                                    class="dark:bg-dark-900 shadow-theme-xs focus:border-brand-300 focus:ring-brand-500/10 dark:focus:border-brand-800 h-11 w-full rounded-lg border border-gray-300 bg-transparent px-4 py-2.5 text-sm text-gray-800 placeholder:text-gray-400 focus:ring-3 focus:outline-hidden dark:border-gray-700 dark:bg-gray-900 dark:text-white/90 dark:placeholder:text-white/30"
                                    value="{{ old('MAIL_PASSWORD', $smtpSettings['MAIL_PASSWORD']) }}" />
                                <x-input-error :messages="$errors->get('MAIL_PASSWORD')" class="mt-2" />
                            </div>

                            <div>
                                <label for="product-name"
                                    class="mb-1.5 block text-sm font-medium text-gray-700 dark:text-gray-400">Mail
                                    Encryption (SSL OR TLS) </label>
                                <input type="text" name="MAIL_ENCRYPTION"
                                    class="dark:bg-dark-900 shadow-theme-xs focus:border-brand-300 focus:ring-brand-500/10 dark:focus:border-brand-800 h-11 w-full rounded-lg border border-gray-300 bg-transparent px-4 py-2.5 text-sm text-gray-800 placeholder:text-gray-400 focus:ring-3 focus:outline-hidden dark:border-gray-700 dark:bg-gray-900 dark:text-white/90 dark:placeholder:text-white/30"
                                    value="{{ old('MAIL_ENCRYPTION', $smtpSettings['MAIL_ENCRYPTION']) }}" />
                                <x-input-error :messages="$errors->get('MAIL_ENCRYPTION')" class="mt-2" />
                            </div>

                            <div>
                                <label for="product-name"
                                    class="mb-1.5 block text-sm font-medium text-gray-700 dark:text-gray-400">Mail
                                    From Address </label>
                                <input type="email" name="MAIL_FROM_ADDRESS"
                                    class="dark:bg-dark-900 shadow-theme-xs focus:border-brand-300 focus:ring-brand-500/10 dark:focus:border-brand-800 h-11 w-full rounded-lg border border-gray-300 bg-transparent px-4 py-2.5 text-sm text-gray-800 placeholder:text-gray-400 focus:ring-3 focus:outline-hidden dark:border-gray-700 dark:bg-gray-900 dark:text-white/90 dark:placeholder:text-white/30"
                                    value="{{ old('MAIL_FROM_ADDRESS', $smtpSettings['MAIL_FROM_ADDRESS']) }}" />
                                <x-input-error :messages="$errors->get('MAIL_FROM_PASSWORD')" class="mt-2" />
                            </div>

                            <div>
                                <label for="product-name"
                                    class="mb-1.5 block text-sm font-medium text-gray-700 dark:text-gray-400">Mail
                                    From Name </label>
                                <input type="text" name="MAIL_FROM_NAME"
                                    class="dark:bg-dark-900 shadow-theme-xs focus:border-brand-300 focus:ring-brand-500/10 dark:focus:border-brand-800 h-11 w-full rounded-lg border border-gray-300 bg-transparent px-4 py-2.5 text-sm text-gray-800 placeholder:text-gray-400 focus:ring-3 focus:outline-hidden dark:border-gray-700 dark:bg-gray-900 dark:text-white/90 dark:placeholder:text-white/30"
                                    value="{{ old('MAIL_FROM_NAME', $smtpSettings['MAIL_FROM_NAME']) }}" />
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Button -->
                <div class="flex flex-col gap-3 sm:flex-row">
                    <button type="submit"
                        class="bg-brand-500 shadow-theme-xs hover:bg-brand-600 inline-flex items-center justify-center gap-2 rounded-lg px-4 py-3 text-sm font-medium text-white transition">
                        Update
                    </button>
                </div>
            </div>
        </form>
        <!-- Content End -->
    </div>


</x-admin>