<x-admin :title="$pageTitle">

    <div class="mx-auto max-w-(--breakpoint-2xl) p-4 pb-20 md:p-6 md:pb-6">
        <!-- Breadcrumb Start -->
        <div x-data="{ pageName: `{{ $pageTitle }}` }">
            <div class="flex flex-wrap items-center justify-between gap-3 pb-6">
                <h2 class="text-xl font-semibold text-gray-800 dark:text-white/90" x-text="pageName"></h2>
                <nav>
                    <ol class="flex items-center gap-1.5">
                        <li>
                            <a class="inline-flex items-center gap-1.5 text-sm text-gray-500 dark:text-gray-400"
                                href="index.html">
                                Home
                                <svg class="stroke-current" width="17" height="16" viewBox="0 0 17 16" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path d="M6.0765 12.667L10.2432 8.50033L6.0765 4.33366" stroke="" stroke-width="1.2"
                                        stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </a>
                        </li>
                        <li class="text-sm text-gray-800 dark:text-white/90" x-text="pageName"></li>
                    </ol>
                </nav>
            </div>
        </div>
        <!-- Breadcrumb End -->

        <!-- Plan -->
        <div class="rounded-xl border border-gray-200 bg-white dark:border-gray-800 dark:bg-white/[0.03]">
            <!-- Feature -->
            <div class="rounded-xl border border-gray-200 bg-white dark:border-gray-800 dark:bg-white/[0.03]">
                <div class="px-6 py-5">
                    <h3 class="text-base font-medium text-gray-800 dark:text-white/90">
                        Deposit Details
                    </h3>
                </div>
                <div class="gap-6 border-t border-gray-200 p-4 sm:p-6 dark:border-gray-800">
                    <!-- List -->
                    <div class="border-t border-gray-200 p-4 sm:p-6 dark:border-gray-800">
                        <ul class="divide-y divide-gray-100 dark:divide-gray-800">
                            <li class="flex items-center gap-5 py-2.5">
                                <span class="w-1/2 text-sm text-gray-500 sm:w-1/3 dark:text-gray-400">Name</span>
                                <span
                                    class="w-1/2 text-sm font-medium text-gray-700 sm:w-2/3 dark:text-gray-400">{{ $data->user->firstname }}
                                    {{ $data->user->lastname }}</span>
                            </li>
                            <li class="flex items-center gap-5 py-2.5">
                                <span class="w-1/2 text-sm text-gray-500 sm:w-1/3 dark:text-gray-400">Method Used</span>
                                <span class="w-1/2 text-sm font-medium text-gray-700 sm:w-2/3 dark:text-gray-400">
                                    {{ $data->method_type}}</span>
                            </li>
                            <li class="flex items-center gap-5 py-2.5">
                                <span class="w-1/2 text-sm text-gray-500 sm:w-1/3 dark:text-gray-400">Bank Name</span>
                                <span class="w-1/2 text-sm font-medium text-gray-700 sm:w-2/3 dark:text-gray-400">
                                    {{ $data->bank_name}}</span>
                            </li>
                            <li class="flex items-center gap-5 py-2.5">
                                <span class="w-1/2 text-sm text-gray-500 sm:w-1/3 dark:text-gray-400">Account
                                    Name</span>
                                <span class="w-1/2 text-sm font-medium text-gray-700 sm:w-2/3 dark:text-gray-400">
                                    {{ $data->account_name}}</span>
                            </li>
                            <li class="flex items-center gap-5 py-2.5">
                                <span class="w-1/2 text-sm text-gray-500 sm:w-1/3 dark:text-gray-400">Account
                                    Number</span>
                                <span class="w-1/2 text-sm font-medium text-gray-700 sm:w-2/3 dark:text-gray-400">
                                    {{ $data->account_number}}</span>
                            </li>
                            <li class="flex items-center gap-5 py-2.5">
                                <span class="w-1/2 text-sm text-gray-500 sm:w-1/3 dark:text-gray-400">Swift Code</span>
                                <span class="w-1/2 text-sm font-medium text-gray-700 sm:w-2/3 dark:text-gray-400">
                                    {{ $data->swift_code}}</span>
                            </li>
                            <li class="flex items-center gap-5 py-2.5">
                                <span class="w-1/2 text-sm text-gray-500 sm:w-1/3 dark:text-gray-400">Amount</span>
                                <span
                                    class="w-1/2 text-sm font-medium text-gray-700 sm:w-2/3 dark:text-gray-400">${{ number_format($data->amount, 2) }}</span>
                            </li>
                            <li class="flex items-center gap-5 py-2.5">
                                <span class="w-1/2 text-sm text-gray-500 sm:w-1/3 dark:text-gray-400">Crypto Type</span>
                                <span class="w-1/2 text-sm font-medium text-gray-700 sm:w-2/3 dark:text-gray-400">
                                    {{ $data->crypto_type}}</span>
                            </li>
                            <li class="flex items-center gap-5 py-2.5">
                                <span class="w-1/2 text-sm text-gray-500 sm:w-1/3 dark:text-gray-400">Crypto
                                    Network</span>
                                <span class="w-1/2 text-sm font-medium text-gray-700 sm:w-2/3 dark:text-gray-400">
                                    {{ $data->network}}</span>
                            </li>
                            <li class="flex items-center gap-5 py-2.5">
                                <span class="w-1/2 text-sm text-gray-500 sm:w-1/3 dark:text-gray-400">Wallet
                                    Address</span>
                                <span class="w-1/2 text-sm font-medium text-gray-700 sm:w-2/3 dark:text-gray-400">
                                    {{ $data->wallet_address}}</span>
                            </li>
                            <li class="flex items-center gap-5 py-2.5">
                                <span class="w-1/2 text-sm text-gray-500 sm:w-1/3 dark:text-gray-400">Status
                                    code</span>
                                <span
                                    class="w-1/2 text-sm font-medium text-gray-700 sm:w-2/3 dark:text-gray-400">{{ $data->status }}</span>
                            </li>
                        </ul>
                        <td class="p-2 mt-3 text-center">
                            @if ($data->status === 'pending')
                                <form action="" method="POST" id="withdrawalActionForm{{ $data->id }}">
                                    @csrf
                                    <label class="mb-1.5 block text-sm font-medium text-gray-700 dark:text-gray-400">
                                        Update Status
                                    </label>
                                    <select name="action"
                                        class="dark:bg-dark-900 shadow-theme-xs focus:border-brand-300 focus:ring-brand-500/10 dark:focus:border-brand-800 h-11 w-full appearance-none rounded-lg border border-gray-300 bg-transparent bg-none px-4 py-3 text-sm text-gray-800 placeholder:text-gray-400 focus:ring-3 focus:outline-hidden dark:border-gray-700 dark:bg-gray-900 dark:text-white/90 dark:placeholder:text-white/30"
                                        onchange="handleWithdrawalAction(this, {{ $data->id }})">
                                        <option value="">Select</option>
                                        <option value="{{ route('withdrawals.approve', $data->id) }}">Approve
                                        </option>
                                        <option value="{{ route('withdrawals.reject', $data->id) }}">Reject
                                        </option>
                                    </select>
                                </form>

                                <script>
                                    function handleWithdrawalAction(select, id) {
                                        const form = document.getElementById(`withdrawalActionForm${id}`);
                                        const route = select.value;

                                        if (route) {
                                            form.action = route;
                                            if (confirm(`Are you sure you want to ${select.options[select.selectedIndex].text.toLowerCase()} this withdrawal?`)) {
                                                form.submit();
                                            } else {
                                                select.value = ""; // Reset selection if canceled
                                            }
                                        }
                                    }
                                </script>
                            @else
                                <span class="text-gray-400 text-xs font-medium">Processed</span>
                            @endif
                        </td>
                    </div>
                </div>
            </div>
        </div>
    </div>

</x-admin>