<!DOCTYPE html>
<html lang="en" x-data="{ darkMode: localStorage.getItem('theme') === 'light' ? false : true }"
    :class="{ 'dark': darkMode }" class="dark bg-gray-900 h-full">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>
        @isset($pageTitle)
            {{ $pageTitle }} - {{ $websiteSettings->site_name }}
        @else
            {{ $websiteSettings->site_name }}
        @endisset
    </title>
    <link rel="icon" href="/user/images/favicon.png" type="image/png">
    <link rel="stylesheet" href="/user/vendor/css/simplebar.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="/user/css/style.css" />
    <link href="/user/vendor/css/tom-select.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
</head>

<body
    class="font-theme flex flex-col h-full text-base font-normal bg-zinc-50 dark:bg-zinc-800 overflow-hidden text-zinc-700 dark:text-zinc-300">

    <!-- ✅ Full-screen centered layout -->
    <main
        class="flex flex-col items-center justify-center flex-1 bg-gradient-to-br from-gray-800 via-gray-800 to-gray-900 bg-cover bg-center px-4 py-10">

        <!-- ✅ Centered Card -->
        <div
            class="max-w-3xl mx-auto w-full rounded-xl bg-white/60 dark:bg-zinc-900/90 shadow-2xl backdrop-blur-lg p-6 sm:p-8 border border-zinc-200 dark:border-zinc-800">

            <!-- Header -->
            <div class="mb-6 flex flex-col items-center text-center">
                <a href="{{ url('/') }}" class="flex items-center justify-center mb-5">
                    <img class="logo-icon" :class="sidebarToggle ? 'xl:block' : 'hidden'"
                        src="{{ asset('upload/' . $websiteSettings->site_logo) }}" alt="Logo"
                        style="height: 50px; width:50px;" />
                </a>

                <h3 class="text-2xl font-semibold text-gray-100 leading-none mb-2.5">
                    Two Factor Authenticator
                </h3>
                <p class="text-sm text-gray-300">
                    Enter 2FA Code
                </p>
            </div>

            <!-- Access Code Form -->
            <form method="POST" action="{{ route('login.2fa.verify') }}">
                @csrf

                <div class="flex flex-col gap-1 mb-2">
                    <label for="access_code" class="block mb-1 text-sm text-gray-300">2FA Code</label>
                    <input id="access_code" name="code" type="text" placeholder="6-digit code"
                        class="input input-lg w-full px-4 py-3 rounded-md bg-white/90 dark:bg-zinc-800 text-gray-900 dark:text-white border border-gray-300 dark:border-gray-700 focus:ring-2 focus:ring-primary focus:outline-none" />
                    @error('code')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <button type="submit"
                    class="btn bg-primary text-white mt-4 hover:bg-primary-deep w-full py-3 rounded-md font-semibold transition duration-300">
                    Verify Code
                </button>
            </form>
        </div>
    </main>

    <!-- jQuery + Toastr -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            toastr.options = {
                "closeButton": true,
                "progressBar": true,
                "positionClass": "toast-top-right",
                "timeOut": "4000"
            };

            @if (session('success'))
                toastr.success("{{ session('success') }}");
            @endif
            @if (session('error'))
                toastr.error("{{ session('error') }}");
            @endif
            @if (session('warning'))
                toastr.warning("{{ session('warning') }}");
            @endif
            @if (session('info'))
                toastr.info("{{ session('info') }}");
            @endif
        });
    </script>

    <script src="/user/js/theme.js"></script>
    <script src="/user/vendor/js/tom-select.complete.min.js"></script>
</body>

</html>