<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Investment Completed - {{ $websiteSettings->site_name }}</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@500;600;700&display=swap" rel="stylesheet" />

    <style>
        body {
            margin: 0;
            padding: 0;
            background: #f5f7fa;
            font-family: 'Inter', sans-serif;
        }

        .container {
            max-width: 480px;
            margin: 40px auto;
            background: #fff;
            border-radius: 20px;
            border: 1px solid #e5e7eb;
            padding: 50px 40px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, .05);
        }

        .logo {
            text-align: center;
            margin-bottom: 25px
        }

        h1 {
            font-size: 22px;
            font-weight: 700;
            color: #111;
            text-align: center;
            margin-bottom: 10px
        }

        h2 {
            font-size: 16px;
            font-weight: 600;
            color: #2563eb;
            text-align: center;
            margin-bottom: 20px
        }

        p {
            text-align: center;
            font-size: 15px;
            line-height: 24px;
            color: #444;
            margin-bottom: 20px
        }

        .button {
            background: #2563eb;
            color: #fff !important;
            padding: 12px 25px;
            border-radius: 8px;
            font-weight: 600;
            text-decoration: none;
            display: inline-block;
            margin-top: 10px
        }

        .footer {
            margin-top: 30px;
            background: #f3f4f6;
            padding: 15px;
            border-radius: 8px;
            text-align: center;
            font-size: 13px;
            color: #6b7280;
        }
    </style>

</head>

<body>
    <div class="container">

        <div class="logo">
            <img src="{{ asset('upload/' . $websiteSettings->site_logo) }}" width="70" />
        </div>

        <h1>Investment Completed</h1>
        <h2>{{ $websiteSettings->site_name }}</h2>

        <p>
            Congratulations <strong>{{ $investment->user->firstname }}</strong>!
            Your investment in the <strong>{{ $investment->plan->name }}</strong> plan has been successfully completed.
        </p>

        <p>
            Profit credited: <strong>${{ number_format($investment->profit, 2) }}</strong><br>
            Total Expected Return: <strong>${{ number_format($investment->expected_return, 2) }}</strong>
        </p>

        <div style="text-align:center;">
            <a class="button" href="{{ route('user.portfolio') }}">View Portfolio</a>
        </div>

        <div class="footer">
            Best regards,<br>
            <strong>{{ $websiteSettings->site_name }} Team</strong>
        </div>

    </div>
</body>

</html>