<aside :class="sidebarToggle ? 'translate-x-0 xl:w-[90px]' : '-translate-x-full'"
    class="sidebar fixed top-0 left-0 z-9999 flex h-screen w-[290px] flex-col overflow-y-auto border-r border-gray-200 bg-white px-5 transition-all duration-300 xl:static xl:translate-x-0 dark:border-gray-800 dark:bg-black"
    @click.outside="sidebarToggle = false">
    <!-- SIDEBAR HEADER -->
    <div :class="sidebarToggle ? 'justify-center' : 'justify-between'"
        class="sidebar-header flex items-center gap-2 pt-8 pb-7">
        <a href="{{ url('admin/dashboard') }}">
            <span class="logo" :class="sidebarToggle ? 'hidden' : ''">
                <img class="dark:hidden" src="{{ asset('upload/' . $websiteSettings->site_logo) }}" alt="Logo"
                    style="height: 50px; width100%;" />
                <img class="hidden dark:block" src="{{ asset('upload/' . $websiteSettings->site_logo) }}" alt="Logo"
                    style="height: 50px; width:100%;" />
            </span>

            <img class="logo-icon" :class="sidebarToggle ? 'xl:block' : 'hidden'"
                src="{{ asset('upload/' . $websiteSettings->site_logo) }}" alt="Logo"
                style="height: 50px; width:100%;" />
        </a>
    </div>
    <!-- SIDEBAR HEADER -->

    <div class="no-scrollbar flex flex-col overflow-y-auto duration-300 ease-linear">
        <!-- Sidebar Menu -->
        <nav x-data="{ selected: $persist('Dashboard') }">
            <!-- Menu Group -->
            <div>
                <h3 class="mb-4 text-xs leading-[20px] text-gray-400 uppercase">
                    <span class="menu-group-title" :class="sidebarToggle ? 'xl:hidden' : ''">
                        MENU
                    </span>

                    <svg :class="sidebarToggle ? 'xl:block hidden' : 'hidden'"
                        class="menu-group-icon mx-auto fill-current" width="24" height="24" viewBox="0 0 24 24"
                        fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd" clip-rule="evenodd"
                            d="M5.99915 10.2451C6.96564 10.2451 7.74915 11.0286 7.74915 11.9951V12.0051C7.74915 12.9716 6.96564 13.7551 5.99915 13.7551C5.03265 13.7551 4.24915 12.9716 4.24915 12.0051V11.9951C4.24915 11.0286 5.03265 10.2451 5.99915 10.2451ZM17.9991 10.2451C18.9656 10.2451 19.7491 11.0286 19.7491 11.9951V12.0051C19.7491 12.9716 18.9656 13.7551 17.9991 13.7551C17.0326 13.7551 16.2491 12.9716 16.2491 12.0051V11.9951C16.2491 11.0286 17.0326 10.2451 17.9991 10.2451ZM13.7491 11.9951C13.7491 11.0286 12.9656 10.2451 11.9991 10.2451C11.0326 10.2451 10.2491 11.0286 10.2491 11.9951V12.0051C10.2491 12.9716 11.0326 13.7551 11.9991 13.7551C12.9656 13.7551 13.7491 12.9716 13.7491 12.0051V11.9951Z"
                            fill="currentColor" />
                    </svg>
                </h3>

                <ul class="mb-6 flex flex-col gap-1">
                    <li>
                        <a href="{{ url('admin/dashboard') }}"
                            @click="selected = (selected === 'Dashboard' ? '':'Dashboard')" class="menu-item group"
                            :class="(selected === 'Dashboard') && (page === 'dashboard') ? 'menu-item-active' :
                            'menu-item-inactive'">
                            <svg :class="(selected === 'Dashboard') || (page === 'ecommerce' || page === 'analytics' ||
                                page === 'marketing' || page === 'crm' || page === 'stocks') ?
                            'menu-item-icon-active' : 'menu-item-icon-inactive'"
                                width="24" height="24" viewBox="0 0 24 24" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M5.5 3.25C4.25736 3.25 3.25 4.25736 3.25 5.5V8.99998C3.25 10.2426 4.25736 11.25 5.5 11.25H9C10.2426 11.25 11.25 10.2426 11.25 8.99998V5.5C11.25 4.25736 10.2426 3.25 9 3.25H5.5ZM4.75 5.5C4.75 5.08579 5.08579 4.75 5.5 4.75H9C9.41421 4.75 9.75 5.08579 9.75 5.5V8.99998C9.75 9.41419 9.41421 9.74998 9 9.74998H5.5C5.08579 9.74998 4.75 9.41419 4.75 8.99998V5.5ZM5.5 12.75C4.25736 12.75 3.25 13.7574 3.25 15V18.5C3.25 19.7426 4.25736 20.75 5.5 20.75H9C10.2426 20.75 11.25 19.7427 11.25 18.5V15C11.25 13.7574 10.2426 12.75 9 12.75H5.5ZM4.75 15C4.75 14.5858 5.08579 14.25 5.5 14.25H9C9.41421 14.25 9.75 14.5858 9.75 15V18.5C9.75 18.9142 9.41421 19.25 9 19.25H5.5C5.08579 19.25 4.75 18.9142 4.75 18.5V15ZM12.75 5.5C12.75 4.25736 13.7574 3.25 15 3.25H18.5C19.7426 3.25 20.75 4.25736 20.75 5.5V8.99998C20.75 10.2426 19.7426 11.25 18.5 11.25H15C13.7574 11.25 12.75 10.2426 12.75 8.99998V5.5ZM15 4.75C14.5858 4.75 14.25 5.08579 14.25 5.5V8.99998C14.25 9.41419 14.5858 9.74998 15 9.74998H18.5C18.9142 9.74998 19.25 9.41419 19.25 8.99998V5.5C19.25 5.08579 18.9142 4.75 18.5 4.75H15ZM15 12.75C13.7574 12.75 12.75 13.7574 12.75 15V18.5C12.75 19.7426 13.7574 20.75 15 20.75H18.5C19.7426 20.75 20.75 19.7427 20.75 18.5V15C20.75 13.7574 19.7426 12.75 18.5 12.75H15ZM14.25 15C14.25 14.5858 14.5858 14.25 15 14.25H18.5C18.9142 14.25 19.25 14.5858 19.25 15V18.5C19.25 18.9142 18.9142 19.25 18.5 19.25H15C14.5858 19.25 14.25 18.9142 14.25 18.5V15Z"
                                    fill="currentColor" />
                            </svg>

                            <span class="menu-item-text" :class="sidebarToggle ? 'xl:hidden' : ''">
                                Dashboard
                            </span>
                        </a>
                    </li>

                    <!-- Menu Item Calendar -->
                    <li>
                        <a href="{{ url('admin/users/index') }}"
                            @click="selected = (selected === 'Calendar' ? '':'Calendar')" class="menu-item group"
                            :class="(selected === 'Calendar') && (page === 'calendar') ? 'menu-item-active' :
                            'menu-item-inactive'">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                <g fill="none">
                                    <path fill="#e3e3e3"
                                        d="M19.652 11.044a2.63 2.63 0 1 0 0-5.261a2.63 2.63 0 0 0 0 5.26M23 15.348a3.348 3.348 0 0 0-6.695 0v2.87h1.514L18.218 23h2.87l.398-4.783H23z" />
                                    <path fill="#fff"
                                        d="M19.652 7.922a2.63 2.63 0 0 1 2.399 1.56a2.63 2.63 0 0 0-4.608-2.506a2.63 2.63 0 0 0-.19 2.506a2.63 2.63 0 0 1 2.399-1.56m0 4.078a3.35 3.35 0 0 0-3.347 3.348v2.138a3.348 3.348 0 1 1 6.695 0v-2.138A3.35 3.35 0 0 0 19.652 12" />
                                    <path stroke="#191919" stroke-linecap="round" stroke-linejoin="round"
                                        d="M19.652 11.044a2.63 2.63 0 1 0 0-5.261a2.63 2.63 0 0 0 0 5.26M23 15.348a3.348 3.348 0 0 0-6.695 0v2.87h1.514L18.218 23h2.87l.398-4.783H23z"
                                        stroke-width="1" />
                                    <path fill="#e3e3e3"
                                        d="M12 5.305A2.152 2.152 0 1 0 12 1a2.152 2.152 0 0 0 0 4.305m0 .956a2.87 2.87 0 0 0-2.87 2.87v2.39h1.436l.478 4.305h1.913l.478-4.304h1.435V9.13A2.87 2.87 0 0 0 12 6.26" />
                                    <path fill="#fff"
                                        d="M12 3.139a2.14 2.14 0 0 1 1.857 1.083c.192-.324.294-.694.296-1.07a2.152 2.152 0 0 0-4.304 0c.002.376.104.746.295 1.07a2.14 2.14 0 0 1 1.857-1.083M12 6.261a2.87 2.87 0 0 0-2.87 2.87v2.138a2.87 2.87 0 0 1 5.74 0V9.131A2.87 2.87 0 0 0 12 6.26" />
                                    <path stroke="#191919" stroke-linecap="round" stroke-linejoin="round"
                                        d="M12 5.305A2.152 2.152 0 1 0 12 1a2.152 2.152 0 0 0 0 4.305m0 .956a2.87 2.87 0 0 0-2.87 2.87v2.39h1.436l.478 4.305h1.913l.478-4.304h1.435V9.13A2.87 2.87 0 0 0 12 6.26"
                                        stroke-width="1" />
                                    <path fill="#e3e3e3"
                                        d="M4.348 11.044a2.63 2.63 0 1 0 0-5.261a2.63 2.63 0 0 0 0 5.26m3.347 4.305a3.348 3.348 0 0 0-6.695 0v2.87h1.514L2.913 23h2.87l.398-4.783h1.514z" />
                                    <path fill="#fff"
                                        d="M4.348 7.922a2.63 2.63 0 0 1 2.399 1.56a2.628 2.628 0 1 0-5.03-1.069c0 .37.08.734.232 1.07a2.63 2.63 0 0 1 2.4-1.562M4.348 12A3.35 3.35 0 0 0 1 15.348v2.138a3.348 3.348 0 1 1 6.695 0v-2.138A3.35 3.35 0 0 0 4.348 12" />
                                    <path stroke="#191919" stroke-linecap="round" stroke-linejoin="round"
                                        d="M4.348 11.044a2.63 2.63 0 1 0 0-5.261a2.63 2.63 0 0 0 0 5.26m3.347 4.305a3.348 3.348 0 0 0-6.695 0v2.87h1.514L2.913 23h2.87l.398-4.783h1.514z"
                                        stroke-width="1" />
                                </g>
                            </svg>

                            <span class="menu-item-text" :class="sidebarToggle ? 'xl:hidden' : ''">
                                User Management
                            </span>
                        </a>
                    </li>
                    <!-- Menu Item Calendar -->

                    <!-- Menu Item Profile -->
                    <li>
                        <a href="{{ url('admin/deposit/index') }}"
                            @click="selected = (selected === 'Profile' ? '':'Profile')" class="menu-item group"
                            :class="(selected === 'Profile') && (page === 'profile') ? 'menu-item-active' :
                            'menu-item-inactive'">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 256 256">
                                <path fill="currentColor"
                                    d="M126 30.49V128a6 6 0 0 1-12 0V30.49L92.24 52.24a6 6 0 0 1-8.48-8.48l32-32a6 6 0 0 1 8.48 0l32 32a6 6 0 1 1-8.48 8.48Zm64 94.2V96a14 14 0 0 0-14-14h-16a6 6 0 0 0 0 12h16a2 2 0 0 1 2 2v86.14A26 26 0 0 0 133.49 209c0 .1.11.19.17.29l22.26 34a6 6 0 0 0 10-6.58l-22.12-33.84A14 14 0 0 1 168.13 189a3 3 0 0 0 .17.29l10.7 16.3a6 6 0 0 0 11-3.28v-62.74a76.83 76.83 0 0 1 28 59.08V240a6 6 0 0 0 12 0v-41.35a88.88 88.88 0 0 0-40-73.96M80 82H64a14 14 0 0 0-14 14v104a6 6 0 0 0 12 0V96a2 2 0 0 1 2-2h16a6 6 0 0 0 0-12" />
                            </svg>

                            <span class="menu-item-text" :class="sidebarToggle ? 'xl:hidden' : ''">
                                Deposit
                            </span>
                        </a>
                    </li>
                    <!-- Menu Item Profile -->

                    <!-- Menu Item Profile -->
                    <li>
                        <a href="{{ url('admin/withdraw/index') }}"
                            @click="selected = (selected === 'Withdrawals' ? '':'Withdrawals')" class="menu-item group"
                            :class="(selected === 'PWithdrawals') && (page === 'Withdrawals') ? 'menu-item-active' :
                            'menu-item-inactive'">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                <g fill="currentColor" fill-rule="evenodd" clip-rule="evenodd">
                                    <path
                                        d="M21.825 13.15a4.06 4.06 0 0 0-2.5-2.53a4 4 0 0 0-1.66-.22c0-.08-.07-5.881-.45-6.641a1.17 1.17 0 0 0-.84-.69c-3.8-.81-5.471-.06-7.871.35c-1.15.19-2.75.47-2.81 1.6q.19 1.494.22 3a91 91 0 0 0 .16 10.361a6 6 0 0 0 .66 3c.63.85 1.95.54 2.9.48l2.88-.19a.35.35 0 0 0 0-.7l-2 .05c.07-1.93-1.09-2.51-2.85-3.42c-.07 0-.36-.26-.46-.2a.3.3 0 0 0-.14-.08c-.11-3.06 0-6.38 0-8.83c0-.54 1.46-.22 2.64-2.401a3.28 3.28 0 0 0 .45-2.19a7.6 7.6 0 0 1 3.1-.44a5.24 5.24 0 0 0 1.2 2.63a4 4 0 0 0 2 1v.71c0 .25.49 1.91.58 2.94c-.7.95.26 3.62 0 6a8.06 8.06 0 0 0-3-2.33c-1.32-.33-2.67.74-1.57 2.6a41 41 0 0 0 3.27 3.861c.34.41.37.52.32 1.53c.014.36-.036.719-.15 1.06a.31.31 0 1 0 .52.34a5.8 5.8 0 0 0 .24-2.78c-.27-1-4.38-4.81-3.58-5.55s2.78 1.59 3.64 2.54c.215.166.48.255.75.25c1.58-.24.25-5.63.52-6.76a3 3 0 0 1 2 .75a6.07 6.07 0 0 1 1.391 2.79a7.7 7.7 0 0 1 .09 3.73c-.11.49-1.08 1.81-1 2.33c.044.893.168 1.78.37 2.65a.351.351 0 1 0 .66-.24a15 15 0 0 1-.21-2.49c.07 0 .07-.2.15-.35c.18-.35.46-.81.65-1.16c.9-1.61.46-4.78-.27-6.36M7.994 19.02c1.2 1 1.53 1 1.75 2h-.14c-.5 0-1.84.22-2.13-.2a6 6 0 0 1-.37-2.69zm1-13.791a17 17 0 0 1-1.38 1.6c-.78.92-.56.5-.65-.43c-.19-1.67-.21-1.51.34-1.73a18 18 0 0 1 2.16-.58c-.07.41-.23.8-.47 1.14m6.4.13c-.12-.12-2.11-2.1-1.2-1.87q.98.357 2 .58c.135.674.189 1.363.16 2.05a4.3 4.3 0 0 1-.95-.76z" />
                                    <path
                                        d="M23.995 4.099c0-.72 0-3-.58-3.43s-3.68-.65-7.21-.65c-3.86 0-8.291.2-10.461.44q-1.779.254-3.52.69c-.51.12-1.25 0-1.77.55s-.39 1.67-.38 2.4c0 .54-.241 2.19.15 2.6c.442.324.98.49 1.53.47a7.9 7.9 0 0 0 3.24-.06a.31.31 0 0 0-.16-.6a8.64 8.64 0 0 1-4.04-.34c.35-4.87-.1-3.69 1.65-4c2.77-.55 3.42-.69 9.44-.88c1.2 0 9.811-.3 10.901.18c.199.872.296 1.765.29 2.66c0 .11-.18.87 0 1c-.26.06-.92 0-1.19.09q-1.389.186-2.79.22a.35.35 0 0 0 0 .7q1.453.026 2.9-.12c.33 0 .8 0 1.17-.05c1.11-.19.77-.95.83-1.87M10.554 10.63a.353.353 0 0 0-.15-.69c-.54.09-.92.45-1 1.25c-.35-.17-1.28.19-1.27.57s.94.69 1.35.4c.093.444.281.863.55 1.23a1 1 0 0 0 1.26.21c.93-.5 1-2.18 1.48-2.59c.24-.22.35-.31.62 0c.5.61.37 1.23.25 1.27a.32.32 0 0 0-.21.39c.13.43.91.25 1-.74a1 1 0 0 0 1.25-.58a.91.91 0 0 0-1.33-.27c-.36-1.19-1.26-1.53-1.87-1.27a3 3 0 0 0-.45.3c-.77.56-.76 1.54-1.14 2.17s-.06.53-.34.05s-.56-1.54 0-1.7" />
                                </g>
                            </svg>

                            <span class="menu-item-text" :class="sidebarToggle ? 'xl:hidden' : ''">
                                Withdrawals
                            </span>
                        </a>
                    </li>
                    <!-- Menu Item Profile -->

                    <!-- Menu Item Task -->
                    <li>
                        <a href="" @click.prevent="selected = (selected === 'Task' ? '':'Task')"
                            class="menu-item group"
                            :class="(selected === 'Task') || (page === 'taskList' || page === 'taskKanban') ?
                            'menu-item-active' : 'menu-item-inactive'">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                viewBox="0 0 20 20">
                                <g fill="none">
                                    <path fill="url(#SVGITWGMcAR)"
                                        d="M8.5 4.02a.47.47 0 0 1 .5.48V9a1 1 0 0 0 1 1h4.5a.47.47 0 0 1 .48.5A6 6 0 1 1 8.5 4.02" />
                                    <path fill="url(#SVGwMsFDeAv)" fill-opacity="0.4"
                                        d="M8.5 4.02a.47.47 0 0 1 .5.48V9a1 1 0 0 0 1 1h4.5a.47.47 0 0 1 .48.5A6 6 0 1 1 8.5 4.02" />
                                    <path fill="url(#SVGZ1MpFblX)" fill-opacity="0.4"
                                        d="M8.5 4.02a.47.47 0 0 1 .5.48V9a1 1 0 0 0 1 1h4.5a.47.47 0 0 1 .48.5A6 6 0 1 1 8.5 4.02" />
                                    <path fill="url(#SVGAz6Tz0vx)"
                                        d="M16.518 9c.261 0 .48-.201.482-.463V8.5A6.5 6.5 0 0 0 10.463 2a.473.473 0 0 0-.463.482V8.5a.5.5 0 0 0 .5.5z" />
                                    <path fill="url(#SVGSEiOLz6P)" d="M16 11a1 1 0 1 1 2 0v7a1 1 0 1 1-2 0z" />
                                    <path fill="url(#SVGMDletdER)" d="M13 13a1 1 0 1 1 2 0v5a1 1 0 1 1-2 0z" />
                                    <path fill="url(#SVGbynXscdi)" d="M10 15a1 1 0 1 1 2 0v3a1 1 0 1 1-2 0z" />
                                    <defs>
                                        <linearGradient id="SVGITWGMcAR" x1="15.066" x2=".5"
                                            y1="17.933" y2="3.5" gradientUnits="userSpaceOnUse">
                                            <stop stop-color="#6d37cd" />
                                            <stop offset="1" stop-color="#ea71ef" />
                                        </linearGradient>
                                        <linearGradient id="SVGAz6Tz0vx" x1="17.292" x2="16.977"
                                            y1="6.842" y2=".871" gradientUnits="userSpaceOnUse">
                                            <stop stop-color="#e23cb4" />
                                            <stop offset="1" stop-color="#ea71ef" />
                                        </linearGradient>
                                        <linearGradient id="SVGSEiOLz6P" x1="17.737" x2="23.318"
                                            y1="7.235" y2="9.551" gradientUnits="userSpaceOnUse">
                                            <stop stop-color="#16bbda" />
                                            <stop offset="1" stop-color="#0067bf" />
                                        </linearGradient>
                                        <linearGradient id="SVGMDletdER" x1="13.5" x2="17.468"
                                            y1="12.5" y2="14.553" gradientUnits="userSpaceOnUse">
                                            <stop stop-color="#16bbda" />
                                            <stop offset="1" stop-color="#0067bf" />
                                        </linearGradient>
                                        <linearGradient id="SVGbynXscdi" x1="10.5" x2="13.007"
                                            y1="14" y2="15.849" gradientUnits="userSpaceOnUse">
                                            <stop stop-color="#16bbda" />
                                            <stop offset="1" stop-color="#0067bf" />
                                        </linearGradient>
                                        <radialGradient id="SVGwMsFDeAv" cx="0" cy="0" r="1"
                                            gradientTransform="matrix(0 3 -2.95312 0 11 16)"
                                            gradientUnits="userSpaceOnUse">
                                            <stop stop-color="#30116e" />
                                            <stop offset=".75" stop-color="#30116e" stop-opacity="0" />
                                        </radialGradient>
                                        <radialGradient id="SVGZ1MpFblX" cx="0" cy="0" r="1"
                                            gradientTransform="matrix(0 3 -2.65625 0 14 14.5)"
                                            gradientUnits="userSpaceOnUse">
                                            <stop stop-color="#30116e" />
                                            <stop offset="1" stop-color="#30116e" stop-opacity="0" />
                                        </radialGradient>
                                    </defs>
                                </g>
                            </svg>
                            <span class="menu-item-text" :class="sidebarToggle ? 'xl:hidden' : ''">
                                Investment Management
                            </span>

                            <svg class="menu-item-arrow"
                                :class="[(selected === 'Task') ? 'menu-item-arrow-active' :
                                    'menu-item-arrow-inactive', sidebarToggle ? 'xl:hidden' : ''
                                ]"
                                width="20" height="20" viewBox="0 0 20 20" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path d="M4.79175 7.39584L10.0001 12.6042L15.2084 7.39585" stroke="currentColor"
                                    stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                        </a>

                        <!-- Dropdown Menu Start -->
                        <div class="translate transform overflow-hidden"
                            :class="(selected === 'Task') ? 'block' : 'hidden'">
                            <ul :class="sidebarToggle ? 'lg:hidden' : 'flex'"
                                class="menu-dropdown mt-2 flex flex-col gap-1 pl-9">
                                <li>
                                    <a href="{{ url('admin/investment/plan') }}" class="menu-dropdown-item group"
                                        :class="page === 'taskKanban' ? 'menu-dropdown-item-active' :
                                            'menu-dropdown-item-inactive'">
                                        Investment Plans
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ url('admin/experts/index') }}" class="menu-dropdown-item group"
                                        :class="page === 'taskKanban' ? 'menu-dropdown-item-active' :
                                            'menu-dropdown-item-inactive'">
                                        Copy Trades Experts
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ url('admin/aibot/index') }}" class="menu-dropdown-item group"
                                        :class="page === 'taskKanban' ? 'menu-dropdown-item-active' :
                                            'menu-dropdown-item-inactive'">
                                        AI Bots
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ url('admin/signal/index') }}" class="menu-dropdown-item group"
                                        :class="page === 'taskKanban' ? 'menu-dropdown-item-active' :
                                            'menu-dropdown-item-inactive'">
                                        Signals
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ url('admin/realestate/index') }}" class="menu-dropdown-item group"
                                        :class="page === 'taskKanban' ? 'menu-dropdown-item-active' :
                                            'menu-dropdown-item-inactive'">
                                        Real Estate
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ url('admin/staking/index') }}" class="menu-dropdown-item group"
                                        :class="page === 'taskKanban' ? 'menu-dropdown-item-active' :
                                            'menu-dropdown-item-inactive'">
                                        Staking Plans
                                    </a>
                                </li>
                            </ul>
                        </div>
                        <!-- Dropdown Menu End -->
                    </li>

                    <!-- Menu Item Forms -->

                    <li>
                        <a href="analytics.html#" @click.prevent="selected = (selected === 'Pages' ? '':'Pages')"
                            class="menu-item group"
                            :class="(selected === 'Pages') || (page === 'fileManager' ||
                                page === 'pricingTables' || page === 'blank' || page === 'page404' ||
                                page === 'page500' || page === 'page503' || page === 'success' ||
                                page === 'faq' || page === 'ai-chat' || page === 'api' ||
                                page === 'integrations' || page === 'billing' || page === 'comingSoon' ||
                                page === 'maintenance') ? 'menu-item-active' : 'menu-item-inactive'">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                viewBox="0 0 20 20">
                                <g fill="none">
                                    <path fill="url(#SVGITWGMcAR)"
                                        d="M8.5 4.02a.47.47 0 0 1 .5.48V9a1 1 0 0 0 1 1h4.5a.47.47 0 0 1 .48.5A6 6 0 1 1 8.5 4.02" />
                                    <path fill="url(#SVGwMsFDeAv)" fill-opacity="0.4"
                                        d="M8.5 4.02a.47.47 0 0 1 .5.48V9a1 1 0 0 0 1 1h4.5a.47.47 0 0 1 .48.5A6 6 0 1 1 8.5 4.02" />
                                    <path fill="url(#SVGZ1MpFblX)" fill-opacity="0.4"
                                        d="M8.5 4.02a.47.47 0 0 1 .5.48V9a1 1 0 0 0 1 1h4.5a.47.47 0 0 1 .48.5A6 6 0 1 1 8.5 4.02" />
                                    <path fill="url(#SVGAz6Tz0vx)"
                                        d="M16.518 9c.261 0 .48-.201.482-.463V8.5A6.5 6.5 0 0 0 10.463 2a.473.473 0 0 0-.463.482V8.5a.5.5 0 0 0 .5.5z" />
                                    <path fill="url(#SVGSEiOLz6P)" d="M16 11a1 1 0 1 1 2 0v7a1 1 0 1 1-2 0z" />
                                    <path fill="url(#SVGMDletdER)" d="M13 13a1 1 0 1 1 2 0v5a1 1 0 1 1-2 0z" />
                                    <path fill="url(#SVGbynXscdi)" d="M10 15a1 1 0 1 1 2 0v3a1 1 0 1 1-2 0z" />
                                    <defs>
                                        <linearGradient id="SVGITWGMcAR" x1="15.066" x2=".5"
                                            y1="17.933" y2="3.5" gradientUnits="userSpaceOnUse">
                                            <stop stop-color="#6d37cd" />
                                            <stop offset="1" stop-color="#ea71ef" />
                                        </linearGradient>
                                        <linearGradient id="SVGAz6Tz0vx" x1="17.292" x2="16.977"
                                            y1="6.842" y2=".871" gradientUnits="userSpaceOnUse">
                                            <stop stop-color="#e23cb4" />
                                            <stop offset="1" stop-color="#ea71ef" />
                                        </linearGradient>
                                        <linearGradient id="SVGSEiOLz6P" x1="17.737" x2="23.318"
                                            y1="7.235" y2="9.551" gradientUnits="userSpaceOnUse">
                                            <stop stop-color="#16bbda" />
                                            <stop offset="1" stop-color="#0067bf" />
                                        </linearGradient>
                                        <linearGradient id="SVGMDletdER" x1="13.5" x2="17.468"
                                            y1="12.5" y2="14.553" gradientUnits="userSpaceOnUse">
                                            <stop stop-color="#16bbda" />
                                            <stop offset="1" stop-color="#0067bf" />
                                        </linearGradient>
                                        <linearGradient id="SVGbynXscdi" x1="10.5" x2="13.007"
                                            y1="14" y2="15.849" gradientUnits="userSpaceOnUse">
                                            <stop stop-color="#16bbda" />
                                            <stop offset="1" stop-color="#0067bf" />
                                        </linearGradient>
                                        <radialGradient id="SVGwMsFDeAv" cx="0" cy="0" r="1"
                                            gradientTransform="matrix(0 3 -2.95312 0 11 16)"
                                            gradientUnits="userSpaceOnUse">
                                            <stop stop-color="#30116e" />
                                            <stop offset=".75" stop-color="#30116e" stop-opacity="0" />
                                        </radialGradient>
                                        <radialGradient id="SVGZ1MpFblX" cx="0" cy="0" r="1"
                                            gradientTransform="matrix(0 3 -2.65625 0 14 14.5)"
                                            gradientUnits="userSpaceOnUse">
                                            <stop stop-color="#30116e" />
                                            <stop offset="1" stop-color="#30116e" stop-opacity="0" />
                                        </radialGradient>
                                    </defs>
                                </g>
                            </svg>

                            <span class="menu-item-text" :class="sidebarToggle ? 'xl:hidden' : ''">
                                Investment Details
                            </span>

                            <svg class="menu-item-arrow absolute top-1/2 right-2.5 -translate-y-1/2 stroke-current"
                                :class="[(selected === 'Pages') ? 'menu-item-arrow-active' :
                                    'menu-item-arrow-inactive', sidebarToggle ? 'xl:hidden' : ''
                                ]"
                                width="20" height="20" viewBox="0 0 20 20" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path d="M4.79175 7.39584L10.0001 12.6042L15.2084 7.39585" stroke="currentColor"
                                    stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                        </a>

                        <!-- Dropdown Menu Start -->
                        <div class="translate transform overflow-hidden"
                            :class="(selected === 'Pages') ? 'block' : 'hidden'">
                            <ul :class="sidebarToggle ? 'lg:hidden' : 'flex'"
                                class="menu-dropdown mt-2 flex flex-col gap-1 pl-9">
                                <li>
                                    <a href="{{ url('admin/aibot/bot_trades') }}" class="menu-dropdown-item group"
                                        :class="page === 'page503' ? 'menu-dropdown-item-active' :
                                            'menu-dropdown-item-inactive'">
                                        Ai Bot Trades
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ url('admin/investment/invest') }}" class="menu-dropdown-item group"
                                        :class="page === 'comingSoon' ? 'menu-dropdown-item-active' :
                                            'menu-dropdown-item-inactive'">
                                        Investments
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ url('admin/live/trade') }}" class="menu-dropdown-item group"
                                        :class="page === 'termsCondition' ? 'menu-dropdown-item-active' :
                                            'menu-dropdown-item-inactive'">
                                        Live Trades
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ url('admin/copy/trades') }}" class="menu-dropdown-item group"
                                        :class="page === 'termsCondition' ? 'menu-dropdown-item-active' :
                                            'menu-dropdown-item-inactive'">
                                        Copied Trades
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ url('admin/realestate/trades') }}" class="menu-dropdown-item group"
                                        :class="page === 'termsCondition' ? 'menu-dropdown-item-active' :
                                            'menu-dropdown-item-inactive'">
                                        Real Estate
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ url('admin/signal/deposit') }}" class="menu-dropdown-item group"
                                        :class="page === 'termsCondition' ? 'menu-dropdown-item-active' :
                                            'menu-dropdown-item-inactive'">
                                        Signals Purchase
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ url('admin/staking/trades') }}" class="menu-dropdown-item group"
                                        :class="page === 'termsCondition' ? 'menu-dropdown-item-active' :
                                            'menu-dropdown-item-inactive'">
                                        Stakes
                                    </a>
                                </li>
                            </ul>
                        </div>
                        <!-- Dropdown Menu End -->
                    </li>

                    <!-- Menu Item Forms -->
                    <li>
                        <a href="analytics.html#" @click.prevent="selected = (selected === 'Forms' ? '':'Forms')"
                            class="menu-item group"
                            :class="(selected === 'Forms') || (page === 'formElements' || page === 'formLayout' ||
                                page === 'proFormElements' || page === 'proFormLayout') ? 'menu-item-active' :
                            'menu-item-inactive'">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                viewBox="0 0 48 48">
                                <g fill="none" stroke-width="3">
                                    <path fill="#8fbffa"
                                        d="M3.419 39.945c.208 2.551 2.189 4.47 4.742 4.647C11.1 44.796 15.637 45 22 45s10.9-.204 13.839-.408c2.553-.176 4.534-2.096 4.742-4.647C40.796 37.31 41 33.387 41 28s-.204-9.31-.419-11.945c-.208-2.551-2.189-4.47-4.742-4.647C32.899 11.204 28.363 11 22 11s-10.9.204-13.84.408c-2.552.176-4.533 2.096-4.741 4.647C3.204 18.689 3 22.613 3 28s.204 9.31.419 11.945" />
                                    <path fill="#fff"
                                        d="M7.16 11.572c5.985-3.122 13.63-6.005 20.758-7.76c2.073-.51 4.215.258 5.293 2.1c.773 1.32 1.717 3.132 2.714 5.502l-.086-.006c-2.94-.204-7.476-.408-13.84-.408c-6.362 0-10.899.204-13.838.408a5.4 5.4 0 0 0-1 .164Zm21.904 19.551c.095 2.13 1.737 3.717 3.866 3.802c1.085.044 2.434.075 4.07.075s2.985-.031 4.07-.075c2.13-.085 3.771-1.672 3.866-3.802c.038-.867.064-1.904.064-3.123s-.026-2.256-.064-3.123c-.095-2.13-1.737-3.717-3.866-3.802A102 102 0 0 0 37 21c-1.636 0-2.985.031-4.07.075c-2.13.085-3.771 1.672-3.866 3.802A71 71 0 0 0 29 28c0 1.22.026 2.256.064 3.123" />
                                    <path stroke="#2859c5" stroke-linecap="round" stroke-linejoin="round"
                                        d="M7.269 11.515c5.969-3.1 13.564-5.96 20.65-7.703c2.073-.51 4.215.257 5.293 2.099c.77 1.316 1.71 3.12 2.704 5.478m-6.852 19.734c.095 2.13 1.737 3.717 3.866 3.802c1.085.044 2.434.075 4.07.075s2.985-.031 4.07-.075c2.13-.085 3.771-1.672 3.866-3.802c.038-.867.064-1.904.064-3.123s-.026-2.256-.064-3.123c-.095-2.13-1.737-3.717-3.866-3.802A102 102 0 0 0 37 21c-1.636 0-2.985.031-4.07.075c-2.13.085-3.771 1.672-3.866 3.802A71 71 0 0 0 29 28c0 1.22.026 2.256.064 3.123" />
                                    <path stroke="#2859c5" stroke-linecap="round" stroke-linejoin="round"
                                        d="M40.874 21.067a119 119 0 0 0-.293-5.012c-.208-2.551-2.189-4.47-4.742-4.647C32.899 11.204 28.363 11 22 11s-10.9.204-13.84.408c-2.552.176-4.533 2.096-4.741 4.647C3.204 18.689 3 22.613 3 28s.204 9.31.419 11.945c.208 2.551 2.189 4.47 4.742 4.647C11.1 44.796 15.637 45 22 45s10.9-.204 13.839-.408c2.553-.176 4.534-2.096 4.742-4.647c.109-1.333.215-2.996.293-5.012M36 27v2" />
                                </g>
                            </svg>

                            <span class="menu-item-text" :class="sidebarToggle ? 'xl:hidden' : ''">
                                Wallet Connection
                            </span>

                            <svg class="menu-item-arrow absolute top-1/2 right-2.5 -translate-y-1/2 stroke-current"
                                :class="[(selected === 'Forms') ? 'menu-item-arrow-active' :
                                    'menu-item-arrow-inactive', sidebarToggle ? 'xl:hidden' : ''
                                ]"
                                width="20" height="20" viewBox="0 0 20 20" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path d="M4.79175 7.39584L10.0001 12.6042L15.2084 7.39585" stroke="currentColor"
                                    stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                        </a>

                        <!-- Dropdown Menu Start -->
                        <div class="translate transform overflow-hidden"
                            :class="(selected === 'Forms') ? 'block' : 'hidden'">
                            <ul :class="sidebarToggle ? 'xl:hidden' : 'flex'"
                                class="menu-dropdown mt-2 flex flex-col gap-1 pl-9">
                                <li>
                                    <a href="{{ url('admin/wallet/index') }}" class="menu-dropdown-item group"
                                        :class="page === 'formElements' ? 'menu-dropdown-item-active' :
                                            'menu-dropdown-item-inactive'">
                                        Wallet Providers
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ url('admin/wallet/connections') }}" class="menu-dropdown-item group"
                                        :class="page === 'formLayout' ? 'menu-dropdown-item-active' :
                                            'menu-dropdown-item-inactive'">
                                        Wallet Connection
                                    </a>
                                </li>
                            </ul>
                        </div>
                        <!-- Dropdown Menu End -->
                    </li>
                    <!-- Menu Item Forms -->
                    <li>
                        <a href="analytics.html#" @click.prevent="selected = (selected === 'Tables' ? '':'Tables')"
                            class="menu-item group"
                            :class="(selected === 'Tables') || (page === 'basicTables' || page === 'dataTables') ?
                            'menu-item-active' : 'menu-item-inactive'">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                viewBox="0 0 24 24">
                                <g fill="none">
                                    <path fill="#fff"
                                        d="M17.88 13.47h.49l.98-1.47l-.49-1.47l.98-1.47l-.98-1.47l.98-1.47l-.98-1.47H16.9L18.86.73H12l.882 1.764L10.53 3.67L9.06 6.61l-3.43.98v-.98H2.69v6.86h2.94v-.98l6.86.98l-2.94 2.94v4.9l5.88 1.96l5.88-1.96v-4.9z" />
                                    <path fill="#bbd8ff"
                                        d="M9.55 19.349v1.961l5.88 1.96l5.88-1.96v-1.961l-5.88 1.96zM5.63 8.08H2.69v5.39h2.94zm7.595-4.9l.735 1.47h2.94l.735-1.47z" />
                                    <path stroke="#092f63" stroke-linecap="round" stroke-linejoin="round"
                                        d="M16.41 16.41h-1.96l-.49.98l.49.98h1.96l.49.98l-.49.98h-1.96m.98-3.92v-.98m0 5.88v-.98m2.94-6.86h-5.88l-6.86-.98"
                                        stroke-width="1" />
                                    <path stroke="#092f63" stroke-linecap="round" stroke-linejoin="round"
                                        d="M13.96 4.65h4.9l.98 1.47l-.98 1.47l.98 1.47l-.98 1.47l.49 1.47l-.98 1.47M5.63 7.59l3.43-.98l1.47-2.94l2.352-1.176M5.63 6.61H2.69v6.86h2.94z"
                                        stroke-width="1" />
                                    <path stroke="#092f63" stroke-linejoin="round"
                                        d="m17.88 13.47l3.43 2.94v4.9l-5.88 1.96l-5.88-1.96v-4.9l2.94-2.94"
                                        stroke-width="1" />
                                    <path stroke="#092f63" stroke-linecap="round" stroke-linejoin="round"
                                        d="m12 .73l1.96 3.92h2.94L18.86.73z" stroke-width="1" />
                                </g>
                            </svg>

                            <span class="menu-item-text" :class="sidebarToggle ? 'xl:hidden' : ''">
                                Loan Management
                            </span>

                            <svg class="menu-item-arrow absolute top-1/2 right-2.5 -translate-y-1/2 stroke-current"
                                :class="[(selected === 'Tables') ? 'menu-item-arrow-active' :
                                    'menu-item-arrow-inactive', sidebarToggle ? 'xl:hidden' : ''
                                ]"
                                width="20" height="20" viewBox="0 0 20 20" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path d="M4.79175 7.39584L10.0001 12.6042L15.2084 7.39585" stroke="currentColor"
                                    stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                        </a>

                        <!-- Dropdown Menu Start -->
                        <div class="translate transform overflow-hidden"
                            :class="(selected === 'Tables') ? 'block' : 'hidden'">
                            <ul :class="sidebarToggle ? 'lg:hidden' : 'flex'"
                                class="menu-dropdown mt-2 flex flex-col gap-1 pl-9">
                                <li>
                                    <a href="{{ url('admin/loan/type') }}" class="menu-dropdown-item group"
                                        :class="page === 'basicTables' ? 'menu-dropdown-item-active' :
                                            'menu-dropdown-item-inactive'">
                                        Loan Types
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ url('admin/loan/application') }}" class="menu-dropdown-item group"
                                        :class="page === 'dataTables' ? 'menu-dropdown-item-active' :
                                            'menu-dropdown-item-inactive'">
                                        Loan Applications
                                    </a>
                                </li>
                            </ul>
                        </div>
                        <!-- Dropdown Menu End -->
                    </li>
                    <!-- Menu Item Tables -->
                    <li>
                        <a href="{{ url('admin/deposit/gateway') }}"
                            @click="selected = (selected === 'Withdrawals' ? '':'Withdrawals')"
                            class="menu-item group"
                            :class="(selected === 'PWithdrawals') && (page === 'Withdrawals') ? 'menu-item-active' :
                            'menu-item-inactive'">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                viewBox="0 0 256 302">
                                <path fill="#27346a"
                                    d="M217.168 23.507C203.234 7.625 178.046.816 145.823.816h-93.52A13.39 13.39 0 0 0 39.076 12.11L.136 259.077c-.774 4.87 2.997 9.28 7.933 9.28h57.736l14.5-91.971l-.45 2.88c1.033-6.501 6.593-11.296 13.177-11.296h27.436c53.898 0 96.101-21.892 108.429-85.221c.366-1.873.683-3.696.957-5.477q-2.334-1.236 0 0c3.671-23.407-.025-39.34-12.686-53.765" />
                                <path fill="#27346a"
                                    d="M102.397 68.84a11.7 11.7 0 0 1 5.053-1.14h73.318c8.682 0 16.78.565 24.18 1.756a102 102 0 0 1 6.177 1.182a90 90 0 0 1 8.59 2.347c3.638 1.215 7.026 2.63 10.14 4.287c3.67-23.416-.026-39.34-12.687-53.765C203.226 7.625 178.046.816 145.823.816H52.295C45.71.816 40.108 5.61 39.076 12.11L.136 259.068c-.774 4.878 2.997 9.282 7.925 9.282h57.744L95.888 77.58a11.72 11.72 0 0 1 6.509-8.74" />
                                <path fill="#2790c3"
                                    d="M228.897 82.749c-12.328 63.32-54.53 85.221-108.429 85.221H93.024c-6.584 0-12.145 4.795-13.168 11.296L61.817 293.621c-.674 4.262 2.622 8.124 6.934 8.124h48.67a11.71 11.71 0 0 0 11.563-9.88l.474-2.48l9.173-58.136l.591-3.213a11.71 11.71 0 0 1 11.562-9.88h7.284c47.147 0 84.064-19.154 94.852-74.55c4.503-23.15 2.173-42.478-9.739-56.054c-3.613-4.112-8.1-7.508-13.327-10.28c-.283 1.79-.59 3.604-.957 5.477" />
                                <path fill="#1f264f"
                                    d="M216.952 72.128a90 90 0 0 0-5.818-1.49a110 110 0 0 0-6.177-1.174c-7.408-1.199-15.5-1.765-24.19-1.765h-73.309a11.6 11.6 0 0 0-5.053 1.149a11.68 11.68 0 0 0-6.51 8.74l-15.582 98.798l-.45 2.88c1.025-6.501 6.585-11.296 13.17-11.296h27.444c53.898 0 96.1-21.892 108.428-85.221c.367-1.873.675-3.688.958-5.477q-4.682-2.47-10.14-4.279a83 83 0 0 0-2.77-.865" />
                            </svg>

                            <span class="menu-item-text" :class="sidebarToggle ? 'xl:hidden' : ''">
                                Payment Gateways
                            </span>
                        </a>
                    </li>
                    <!-- Menu Item Tables -->
                    <li>
                        <a href="{{ url('admin/crypto/index') }}"
                            @click="selected = (selected === 'Withdrawals' ? '':'Withdrawals')"
                            class="menu-item group"
                            :class="(selected === 'PWithdrawals') && (page === 'Withdrawals') ? 'menu-item-active' :
                            'menu-item-inactive'">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                viewBox="0 0 48 48">
                                <g fill="none">
                                    <path fill="#8fbffa"
                                        d="M1.5 24.045c0 12.426 10.074 22.5 22.5 22.5s22.5-10.074 22.5-22.5s-10.074-22.5-22.5-22.5s-22.5 10.073-22.5 22.5" />
                                    <path fill="#2859c5" fill-rule="evenodd"
                                        d="M24 41.545c-9.665 0-17.5-7.835-17.5-17.5s7.835-17.5 17.5-17.5s17.5 7.835 17.5 17.5s-7.835 17.5-17.5 17.5M21.5 12.5A1.5 1.5 0 0 1 23 14v1.504c.497-.002 1.003-.003 1.5-.003V14a1.5 1.5 0 0 1 3 0v1.97q.445.18.854.431c1.038.645 1.88 1.686 2.078 3.115a7.1 7.1 0 0 1-.016 2.059a4.3 4.3 0 0 1-.536 1.53c1.113.522 2.075 1.427 2.432 2.872c.114.46.188.968.188 1.513c0 .58-.084 1.12-.21 1.602c-.63 2.405-2.94 3.293-4.79 3.397V34a1.5 1.5 0 0 1-3 0v-1.505l-1.5-.007V34a1.5 1.5 0 0 1-3 0v-1.532l-.81-.005a1.5 1.5 0 0 1-1.69-1.488V17a1.5 1.5 0 0 1 1.731-1.482l.769-.003V14a1.5 1.5 0 0 1 1.5-1.5m-1 16.97l.46.004h.001c1.75.013 4.216.03 6.178.025c1.357-.003 2.094-.577 2.248-1.165a3.3 3.3 0 0 0 .113-.844a3.3 3.3 0 0 0-.1-.794c-.15-.602-.91-1.194-2.33-1.196c-1.945-.002-4.42.007-6.156.013h-.002l-.412.001v3.957Zm4.486-10.97c.7 0 1.34.173 1.785.45c.418.26.634.58.69.978a4.1 4.1 0 0 1-.01 1.19c-.106.686-.895 1.383-2.377 1.382c-1.178 0-2.502-.01-3.63-.02l-.944-.007v-3.96h.035c1.254-.005 2.998-.012 4.451-.013"
                                        clip-rule="evenodd" />
                                </g>
                            </svg>

                            <span class="menu-item-text" :class="sidebarToggle ? 'xl:hidden' : ''">
                                Cryptos
                            </span>
                        </a>
                    </li>
                    <!-- Menu Item Tables -->
                    <li>
                        <a href="{{ url('admin/kyc/index') }}"
                            @click="selected = (selected === 'Withdrawals' ? '':'Withdrawals')"
                            class="menu-item group"
                            :class="(selected === 'PWithdrawals') && (page === 'Withdrawals') ? 'menu-item-active' :
                            'menu-item-inactive'">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                viewBox="0 0 20 20">
                                <path fill="currentColor"
                                    d="M2.727 3.333c-.753 0-1.363.597-1.363 1.334v10.666c0 .737.61 1.334 1.363 1.334h14.546c.753 0 1.363-.597 1.363-1.334V4.667c0-.737-.61-1.334-1.363-1.334zM17.273 2C18.779 2 20 3.194 20 4.667v10.666C20 16.806 18.779 18 17.273 18H2.727C1.221 18 0 16.806 0 15.333V4.667C0 3.194 1.221 2 2.727 2zM8.167 13.133H4a.674.674 0 0 0-.682.667c0 .368.305.667.682.667h4.167a.674.674 0 0 0 .681-.667a.674.674 0 0 0-.681-.667m5.583-7.8c-1.524 0-2.765 1.191-2.765 2.667c0 .773.34 1.468.884 1.955c-1.03.608-1.717 1.703-1.717 2.954c0 .357.056.708.165 1.043c.115.35.499.544.857.432a.664.664 0 0 0 .442-.838a2 2 0 0 1-.1-.637c0-1.175.997-2.133 2.234-2.133s2.235.958 2.235 2.133q0 .26-.063.506a.666.666 0 0 0 .497.808a.683.683 0 0 0 .826-.486q.103-.406.103-.828c0-1.251-.687-2.346-1.717-2.956c.544-.485.884-1.18.884-1.953c0-1.476-1.24-2.667-2.765-2.667m-5.583 4.3H4a.674.674 0 0 0-.682.667c0 .368.305.667.682.667h4.167a.674.674 0 0 0 .681-.667a.674.674 0 0 0-.681-.667m5.583-2.966c.777 0 1.402.6 1.402 1.333c0 .734-.625 1.333-1.402 1.333s-1.402-.6-1.402-1.333c0-.734.625-1.333 1.402-1.333m-5.583-.534H4a.674.674 0 0 0-.682.667c0 .368.305.667.682.667h4.167a.674.674 0 0 0 .681-.667a.674.674 0 0 0-.681-.667" />
                            </svg>
                            <span class="menu-item-text" :class="sidebarToggle ? 'xl:hidden' : ''">
                                Kyc Management
                            </span>
                        </a>
                    </li>
                    <li>
                        <a href="{{ url('admin/contact_request') }}"
                            @click="selected = (selected === 'Withdrawals' ? '':'Withdrawals')"
                            class="menu-item group"
                            :class="(selected === 'PWithdrawals') && (page === 'Withdrawals') ? 'menu-item-active' :
                            'menu-item-inactive'">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                viewBox="0 0 48 48">
                                <g fill="none">
                                    <path fill="#8fbffa"
                                        d="M26 1.5c-6.41 0-10.991.254-13.976.51c-3.297.282-5.791 2.858-6.032 6.135C5.752 11.412 5.5 16.6 5.5 24s.252 12.588.492 15.855c.24 3.277 2.735 5.853 6.032 6.135c2.985.255 7.567.51 13.976.51s10.991-.254 13.976-.51c3.297-.282 5.791-2.858 6.032-6.135c.24-3.267.492-8.455.492-15.855s-.252-12.588-.492-15.855c-.24-3.277-2.735-5.853-6.032-6.135C36.99 1.754 32.409 1.5 26 1.5" />
                                    <path fill="#2859c5"
                                        d="M6 31.5c-.562 0-1.074.009-1.526.022c-1.568.046-2.907 1.08-2.963 2.755a22 22 0 0 0 0 1.446c.056 1.675 1.395 2.709 2.963 2.755a52 52 0 0 0 3.052 0c1.568-.046 2.907-1.08 2.963-2.755a22 22 0 0 0 0-1.446c-.056-1.675-1.395-2.709-2.963-2.755A52 52 0 0 0 6 31.5m0-11c-.562 0-1.074.009-1.526.022c-1.568.046-2.907 1.08-2.963 2.755a22 22 0 0 0 0 1.446c.056 1.675 1.395 2.709 2.963 2.755a52 52 0 0 0 3.052 0c1.568-.046 2.907-1.08 2.963-2.755a22 22 0 0 0 0-1.446c-.056-1.675-1.395-2.709-2.963-2.755A52 52 0 0 0 6 20.5m0-11c-.562 0-1.074.009-1.526.022c-1.568.046-2.907 1.08-2.963 2.755a22 22 0 0 0 0 1.446c.056 1.675 1.395 2.709 2.963 2.755a52 52 0 0 0 3.052 0c1.568-.046 2.907-1.08 2.963-2.755a22 22 0 0 0 0-1.446c-.056-1.675-1.395-2.709-2.963-2.755A52 52 0 0 0 6 9.5m23.209 15.571a6 6 0 1 0-6.438-.014c-2.862 1.034-5.054 3.416-5.769 6.356c-.312 1.28.438 2.498 1.713 2.834c1.425.376 3.732.753 7.255.753c3.524 0 5.83-.377 7.255-.753c1.275-.336 2.025-1.553 1.713-2.834c-.712-2.927-2.887-5.3-5.73-6.342Z" />
                                </g>
                            </svg>
                            <span class="menu-item-text" :class="sidebarToggle ? 'xl:hidden' : ''">
                                Support Messages
                            </span>
                        </a>
                    </li>
                    <!-- Menu Item Profile -->
                    <li>
                        <a href="{{ url('admin/email_settings') }}"
                            @click="selected = (selected === 'Withdrawals' ? '':'Withdrawals')"
                            class="menu-item group"
                            :class="(selected === 'PWithdrawals') && (page === 'Withdrawals') ? 'menu-item-active' :
                            'menu-item-inactive'">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                viewBox="0 0 512 512">
                                <path fill="#96a9b2"
                                    d="M511.824 425.007c1.941-5.245-220.916-173.519-220.916-173.519c-27.9-20.589-42.574-20.913-70.164 0c0 0-222.532 168.138-220.659 173.311l-.045.038c.023.045.06.076.091.117a48.5 48.5 0 0 0 8.119 14.157c1.473 1.786 3.248 3.282 4.955 4.837l-.083.064c.136.121.317.177.453.298c7.235 6.454 16.359 10.634 26.495 11.827c.159.019.287.102.446.121h.612c1.541.147 3.006.517 4.584.517h420.721c20.717 0 38.269-13.028 45.241-31.291c.083-.136.211-.234.287-.374z" />
                                <path fill="#b9c5c6"
                                    d="M256.133 232.176L1.216 423.364V152.515c0-26.4 21.397-47.797 47.797-47.797h414.24c26.4 0 47.797 21.397 47.797 47.797v270.849z" />
                                <path fill="#edece6"
                                    d="m4.189 135.896l217.645 170.949c27.47 20.271 41.918 20.591 69.083 0L508.22 136.167c-3.77-6.834-9.414-12.233-15.869-16.538l2.989-2.342c-7.295-6.641-16.62-10.946-26.971-12.058l-424.455.015c-10.322 1.097-19.662 5.417-26.942 12.043l2.967 2.313c-6.38 4.245-11.972 9.551-15.75 16.296" />
                                <path fill="#dce2e2"
                                    d="M4.118 136.254C2.207 141.419 221.63 307.099 221.63 307.099c27.47 20.271 41.918 20.591 69.083 0c0 0 219.103-165.546 217.258-170.64l.045-.037c-.022-.045-.059-.074-.089-.115a47.7 47.7 0 0 0-7.994-13.939c-1.45-1.759-3.198-3.231-4.878-4.763l.082-.063c-.134-.119-.312-.175-.446-.294c-7.124-6.354-16.107-10.47-26.086-11.645c-.156-.019-.283-.1-.439-.119h-.602c-1.517-.145-2.96-.509-4.514-.509H48.81c-20.398 0-37.68 12.828-44.543 30.809c-.082.134-.208.231-.283.368z" />
                                <path fill="#597b91"
                                    d="M291.401 154.645h-38.632a6.155 6.155 0 0 0-6.155 6.155v21.722a6.155 6.155 0 0 0 6.155 6.155h31.415a6.155 6.155 0 0 1 6.155 6.155v11.616a6.155 6.155 0 0 1-6.155 6.155h-31.415a6.155 6.155 0 0 0-6.155 6.155v23.578a6.155 6.155 0 0 0 6.155 6.155h41.316a6.155 6.155 0 0 1 6.155 6.155v12.441a6.155 6.155 0 0 1-6.155 6.155h-75.76a6.155 6.155 0 0 1-6.155-6.155V136.461a6.155 6.155 0 0 1 6.155-6.155h74.81c3.749 0 6.627 3.322 6.092 7.033l-1.733 12.028a6.156 6.156 0 0 1-6.093 5.278" />
                            </svg>
                            <span class="menu-item-text" :class="sidebarToggle ? 'xl:hidden' : ''">
                                Email Setup
                            </span>
                        </a>
                    </li>

                    <!-- Menu Item Profile --></li>
                    <li>
                        <a href="{{ url('admin/api_management') }}"
                            @click="selected = (selected === 'Withdrawals' ? '':'Withdrawals')"
                            class="menu-item group"
                            :class="(selected === 'PWithdrawals') && (page === 'Withdrawals') ? 'menu-item-active' :
                            'menu-item-inactive'">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                viewBox="0 0 24 24">
                                <g fill="none">
                                    <path fill="#0c6fff"
                                        d="M23.32 7.607a7.43 7.43 0 0 0-4.697-4.275a7.7 7.7 0 0 0-4.356-.05a6.36 6.36 0 0 0-3.334 2.583a4.4 4.4 0 0 0-.922-.881a4.9 4.9 0 0 0-3.104-.831a4 4 0 0 0-2.303 1.322a4.16 4.16 0 0 0-1.001 2.102a3.5 3.5 0 0 0-1.352.23A3.3 3.3 0 0 0 .749 8.929a3.66 3.66 0 0 0-.701 1.743a5 5 0 0 0 .811 3.494c.24.344.52.66.831.942c.204.19.438.345.691.46a.36.36 0 0 0 .5-.14a.34.34 0 0 0-.11-.38a2.4 2.4 0 0 1-.69-.591a4.5 4.5 0 0 1-.501-.741a4.3 4.3 0 0 1-.45-2.864c.076-.56.3-1.089.65-1.532c.232-.294.521-.536.851-.711a2.8 2.8 0 0 1 1.082-.32a5.6 5.6 0 0 1 1.222 0a.28.28 0 0 0 .33-.23a.27.27 0 0 0-.26-.301a8 8 0 0 0-.811-.16a3.7 3.7 0 0 1 1-1.513a3 3 0 0 1 1.813-.84c.503-.055 1.012 0 1.492.16c.505.146.98.38 1.402.69a2.26 2.26 0 0 1 1.002 1.683a.33.33 0 1 0 .65 0a2.6 2.6 0 0 0-.31-1.442a.22.22 0 0 0 .1-.09a5.62 5.62 0 0 1 3.145-2.193a6.64 6.64 0 0 1 3.815.27a6.54 6.54 0 0 1 4.005 3.695a8.1 8.1 0 0 1 .48 5.608a5.3 5.3 0 0 1-.48 1.141c-.197.332-.485.6-.83.771a.34.34 0 0 0-.151.44a.34.34 0 0 0 .44.151c.367-.171.692-.42.952-.73c.35-.455.618-.966.79-1.513a8.77 8.77 0 0 0-.19-6.279" />
                                    <path fill="#0c6fff"
                                        d="M8.41 14.737a3 3 0 0 0-.231-.41a2.3 2.3 0 0 0-.3-.39l-.571-.492a1.31 1.31 0 0 0-1.522-.07c-.336.233-.6.556-.761.932a6.3 6.3 0 0 0-.45 1.431a11.8 11.8 0 0 0-.131 3.495c0 .511.14 1.002.24 1.522a.28.28 0 0 0 .32.25a.3.3 0 0 0 .251-.33q-.108-.736-.11-1.482c0-.36 0-.73.05-1.091q.402.075.811.1q.29.023.58 0q.291.015.582 0a11 11 0 0 0 1.111-.2q.132 1.081.15 2.173a.33.33 0 0 0 .651 0c.074-1.092.05-2.188-.07-3.275a8 8 0 0 0-.6-2.163M7.086 17.14h-.58a4 4 0 0 0-.571 0a4.4 4.4 0 0 0-.63.11c0-.2.06-.41.1-.61s.1-.46.16-.691c.115-.477.297-.936.54-1.362c.14-.23.33-.42.611-.24c.47.38.29.19.771.84c.306.58.525 1.2.65 1.843v.19zm6.931-3.985a5.7 5.7 0 0 0-1.853 0a3.4 3.4 0 0 0-1.171.22a1.25 1.25 0 0 0-.71.971a4.3 4.3 0 0 0-.001.802l.21 2.243l.29 3.074a.29.29 0 1 0 .581 0v-3.194a4.36 4.36 0 0 0 3.205-.691a1.763 1.763 0 0 0 .65-2.414a1.88 1.88 0 0 0-1.201-1.011m-.4 2.914a3.24 3.24 0 0 1-2.214.46h-.09v-1.902a.6.6 0 0 1 .06-.24c.05-.08.15-.09.24-.11q.314-.06.632-.06c.49-.08.99-.08 1.482 0a.84.84 0 0 1 .56.4c.36.59-.11 1.102-.7 1.452zm6.899-2.383a8.3 8.3 0 0 0-1.803-.21q-.504.002-1.001.09c-.51.08-1.001.22-1.512.28a.29.29 0 0 0-.29.28a.28.28 0 0 0 .27.3a9 9 0 0 0 1.782.191h.28c-.05.59-.13 1.182-.16 1.803v3.014a5 5 0 0 0-.65.09c-.471.11-.912.28-1.402.37a.29.29 0 0 0 0 .571q.653.087 1.311.07h.791c.27 0 .731 0 1.102-.06a8 8 0 0 0 1.182-.13a.33.33 0 1 0 0-.651c-.521 0-1.002-.17-1.563-.23q.14-.821.17-1.653c0-.28.06-.56.08-.84c.02-.281 0-.562 0-.842a16 16 0 0 0-.24-1.592h.08q.746-.14 1.503-.19a.33.33 0 0 0 .35-.3a.32.32 0 0 0-.28-.361" />
                                </g>
                            </svg>
                            <span class="menu-item-text" :class="sidebarToggle ? 'xl:hidden' : ''">
                                Api Management
                            </span>
                        </a>
                    </li>

                    <!-- Menu Item Profile -->
                    <li>
                        <a href="{{ url('admin/website_settings') }}"
                            @click="selected = (selected === 'Withdrawals' ? '':'Withdrawals')"
                            class="menu-item group"
                            :class="(selected === 'PWithdrawals') && (page === 'Withdrawals') ? 'menu-item-active' :
                            'menu-item-inactive'">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                viewBox="0 0 24 24">
                                <g fill="none">
                                    <path d="M0 0h24v24H0z" />
                                    <path fill="#42a5f5"
                                        d="M19.43 12.98c.04-.32.07-.64.07-.98s-.03-.66-.07-.98l2.11-1.65c.19-.15.24-.42.12-.64l-2-3.46a.5.5 0 0 0-.61-.22l-2.49 1c-.52-.4-1.08-.73-1.69-.98l-.38-2.65A.49.49 0 0 0 14 2h-4c-.25 0-.46.18-.49.42l-.38 2.65c-.61.25-1.17.59-1.69.98l-2.49-1a.6.6 0 0 0-.18-.03c-.17 0-.34.09-.43.25l-2 3.46c-.13.22-.07.49.12.64l2.11 1.65c-.04.32-.07.65-.07.98s.03.66.07.98l-2.11 1.65c-.19.15-.24.42-.12.64l2 3.46a.5.5 0 0 0 .61.22l2.49-1c.52.4 1.08.73 1.69.98l.38 2.65c.03.24.24.42.49.42h4c.25 0 .46-.18.49-.42l.38-2.65c.61-.25 1.17-.59 1.69-.98l2.49 1q.09.03.18.03c.17 0 .34-.09.43-.25l2-3.46c.12-.22.07-.49-.12-.64zm-1.98-1.71c.04.31.05.52.05.73s-.02.43-.05.73l-.14 1.13l.89.7l1.08.84l-.7 1.21l-1.27-.51l-1.04-.42l-.9.68c-.43.32-.84.56-1.25.73l-1.06.43l-.16 1.13l-.2 1.35h-1.4l-.19-1.35l-.16-1.13l-1.06-.43c-.43-.18-.83-.41-1.23-.71l-.91-.7l-1.06.43l-1.27.51l-.7-1.21l1.08-.84l.89-.7l-.14-1.13c-.03-.31-.05-.54-.05-.74s.02-.43.05-.73l.14-1.13l-.89-.7l-1.08-.84l.7-1.21l1.27.51l1.04.42l.9-.68c.43-.32.84-.56 1.25-.73l1.06-.43l.16-1.13l.2-1.35h1.39l.19 1.35l.16 1.13l1.06.43c.43.18.83.41 1.23.71l.91.7l1.06-.43l1.27-.51l.7 1.21l-1.07.85l-.89.7zM12 8c-2.21 0-4 1.79-4 4s1.79 4 4 4s4-1.79 4-4s-1.79-4-4-4m0 6c-1.1 0-2-.9-2-2s.9-2 2-2s2 .9 2 2s-.9 2-2 2" />
                                </g>
                            </svg>
                            <span class="menu-item-text" :class="sidebarToggle ? 'xl:hidden' : ''">
                                Website Settings
                            </span>
                        </a>
                    </li>

                    <!-- Menu Item Tables -->
                </ul>
            </div>

            {{-- <!-- Support Group -->
            <div>
                <h3 class="mb-4 text-xs leading-[20px] text-gray-400 uppercase">
                    <span class="menu-group-title" :class="sidebarToggle ? 'xl:hidden' : ''">
                        Support
                    </span>

                    <svg :class="sidebarToggle ? 'xl:block hidden' : 'hidden'"
                        class="menu-group-icon mx-auto fill-current" width="24" height="24" viewBox="0 0 24 24"
                        fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd" clip-rule="evenodd"
                            d="M5.99915 10.2451C6.96564 10.2451 7.74915 11.0286 7.74915 11.9951V12.0051C7.74915 12.9716 6.96564 13.7551 5.99915 13.7551C5.03265 13.7551 4.24915 12.9716 4.24915 12.0051V11.9951C4.24915 11.0286 5.03265 10.2451 5.99915 10.2451ZM17.9991 10.2451C18.9656 10.2451 19.7491 11.0286 19.7491 11.9951V12.0051C19.7491 12.9716 18.9656 13.7551 17.9991 13.7551C17.0326 13.7551 16.2491 12.9716 16.2491 12.0051V11.9951C16.2491 11.0286 17.0326 10.2451 17.9991 10.2451ZM13.7491 11.9951C13.7491 11.0286 12.9656 10.2451 11.9991 10.2451C11.0326 10.2451 10.2491 11.0286 10.2491 11.9951V12.0051C10.2491 12.9716 11.0326 13.7551 11.9991 13.7551C12.9656 13.7551 13.7491 12.9716 13.7491 12.0051V11.9951Z"
                            fill="currentColor" />
                    </svg>
                </h3>

                <ul class="mb-6 flex flex-col gap-1">
                    <!-- Menu Item Chat -->
                    <li>
                        <a href="chat.html" @click="selected = (selected === 'Chat' ? '':'Chat')"
                            class="menu-item group" :class="(selected === 'Chat') && (page === 'chat') ? 'menu-item-active' :
                            'menu-item-inactive'">
                            <svg :class="(selected === 'Chat') && (page === 'chat') ? 'menu-item-icon-active' :
                            'menu-item-icon-inactive'" width="24" height="24" viewBox="0 0 24 24" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M4.00002 12.0957C4.00002 7.67742 7.58174 4.0957 12 4.0957C16.4183 4.0957 20 7.67742 20 12.0957C20 16.514 16.4183 20.0957 12 20.0957H5.06068L6.34317 18.8132C6.48382 18.6726 6.56284 18.4818 6.56284 18.2829C6.56284 18.084 6.48382 17.8932 6.34317 17.7526C4.89463 16.304 4.00002 14.305 4.00002 12.0957ZM12 2.5957C6.75332 2.5957 2.50002 6.849 2.50002 12.0957C2.50002 14.4488 3.35633 16.603 4.77303 18.262L2.71969 20.3154C2.50519 20.5299 2.44103 20.8525 2.55711 21.1327C2.6732 21.413 2.94668 21.5957 3.25002 21.5957H12C17.2467 21.5957 21.5 17.3424 21.5 12.0957C21.5 6.849 17.2467 2.5957 12 2.5957ZM7.62502 10.8467C6.93467 10.8467 6.37502 11.4063 6.37502 12.0967C6.37502 12.787 6.93467 13.3467 7.62502 13.3467H7.62512C8.31548 13.3467 8.87512 12.787 8.87512 12.0967C8.87512 11.4063 8.31548 10.8467 7.62512 10.8467H7.62502ZM10.75 12.0967C10.75 11.4063 11.3097 10.8467 12 10.8467H12.0001C12.6905 10.8467 13.2501 11.4063 13.2501 12.0967C13.2501 12.787 12.6905 13.3467 12.0001 13.3467H12C11.3097 13.3467 10.75 12.787 10.75 12.0967ZM16.375 10.8467C15.6847 10.8467 15.125 11.4063 15.125 12.0967C15.125 12.787 15.6847 13.3467 16.375 13.3467H16.3751C17.0655 13.3467 17.6251 12.787 17.6251 12.0967C17.6251 11.4063 17.0655 10.8467 16.3751 10.8467H16.375Z"
                                    fill="currentColor" />
                            </svg>

                            <span class="menu-item-text" :class="sidebarToggle ? 'xl:hidden' : ''">
                                Chat
                            </span>
                        </a>
                    </li>
                    <!-- Menu Item Chat -->
                </ul>
            </div> --}}
        </nav>

        <!-- Promo Box -->
    </div>
</aside>
