<div class="bg-zinc-50/80 backdrop-blur-sm dark:bg-zinc-950 shrink-0 px-4 lg:px-8 z-50 sticky top-0 app-header">
    <div class="relative py-4 lg:py-0 flex flex-wrap items-center justify-center">
        <div class="shrink-0 flex items-center space-x-1">
            <!--:Sidebar toggler:-->
            <button type="button" data-toggle="app_sidebar"
                class="cursor-pointer relative flex items-center justify-center size-8 rounded-lg hover:bg-zinc-200 hover:text-black dark:hover:text-white dark:hover:bg-zinc-800 lg:hidden">
                <span class="icon-[iconoir--menu] text-lg"></span>
            </button>
            <!--:Search:-->
            <script src="//unpkg.com/alpinejs" defer></script>
            {{--
            <div x-data="{ showBalance: true }" x-init="setInterval(() => showBalance = !showBalance, 3000)"
                class="ml-4 relative w-48 h-8 bg-zinc-800 overflow-hidden rounded-md shadow">

                <!-- Sliding container: double height of parent -->
                <div class="absolute w-full h-24 transition-transform duration-500"
                    :class="showBalance ? 'translate-y-0' : '-translate-y-1/2'">

                    <!-- Balance -->
                    <div class="w-full h-8 flex items-center justify-center">
                        <span class="text-gray-200 font-semibold">
                            Balance: ${{ number_format(Auth::user()->balance, 2) }}
                        </span>
                    </div>

                    <!-- Profit -->
                    <div class="w-full h-8 flex items-center justify-center">
                        <span class="text-green-400 font-semibold">
                            Profit: ${{ number_format(Auth::user()->profit, 2) }}
                        </span>
                    </div>

                </div>
            </div> --}}

            <div class="ml-4 relative w-48 h-8 bg-zinc-800 overflow-hidden rounded-md shadow">

                <!-- Sliding container: wide enough to hold repeated content -->
                <div class="absolute flex whitespace-nowrap animate-marquee">
                    @if (empty(Auth::user()->alert))
                        <!-- Balance -->
                        <div class="px-4 h-8 flex items-center justify-center">
                            <span class="text-gray-200 font-semibold">
                                Balance: ${{ number_format(Auth::user()->balance, 2) }}
                            </span>
                        </div>

                        <!-- Profit -->
                        <div class="px-4 flex h-8 items-center justify-center">
                            <span class="text-green-500 font-semibold">
                                Profit: ${{ number_format(Auth::user()->profit, 2) }}
                            </span>
                        </div>

                        <!-- Total Deposit -->
                        <div class="px-4 flex h-8 items-center justify-center">
                            <span class="text-gray-200 font-semibold">
                                Total Deposit: ${{ number_format($totalDeposits, 2) }}
                            </span>
                        </div>

                        <!-- Total Withdrawal -->
                        <div class="px-4 flex h-8 items-center justify-center">
                            <span class="text-green-500 font-semibold">
                                Total Withdrawal: ${{ number_format($totalWithdrawals, 2) }}
                            </span>
                        </div>
                    @else
                        <!-- Show ONLY the alert -->
                        <div class="px-4 h-8 flex items-center justify-center">
                            <span class="text-yellow-400 font-semibold">
                                {{ Auth::user()->alert }}
                            </span>
                        </div>
                    @endif
                </div>
            </div>

            <style>
                @keyframes marquee {
                    0% {
                        transform: translateX(100%);
                    }

                    100% {
                        transform: translateX(-100%);
                    }
                }

                .animate-marquee {
                    animation: marquee 20s linear infinite;
                }
            </style>


        </div>
        <div class="flex items-center space-x-1 shrink-0 ms-auto lg:order-last">
            <input class="input-switch" data-theme-switch="dark" name="check_theme" type="checkbox" value="1">
            {{-- <button type="button" data-bs-toggle="collapse" data-bs-target="#appNavbar" aria-label="toggle navbar"
                class="cursor-pointer relative flex items-center justify-center size-8 rounded-lg hover:bg-zinc-200 dark:hover:text-white dark:hover:bg-zinc-800 lg:hidden">
                <span class="icon-[lucide--text-align-center] text-lg"></span>
            </button> --}}
            <!--:TLang:-->
            <!--:Theme Lang switcher:-->
            {{-- <div class="relative">
                <button data-bs-auto-close="outside" type="button"
                    class="cursor-pointer relative flex items-center justify-center size-8 rounded-lg hover:bg-zinc-200 hover:text-black dark:hover:text-white dark:hover:bg-zinc-800"
                    data-bs-toggle="dropdown" data-bs-display="static">
                    <img src="/user/images/countries/US.png" class="size-4 rounded-full" alt="">
                </button>
                <div class="dropdown-menu absolute min-w-36 abslute ltr:right-0 rtl:left-0 top-full z-50 mt-4.5">
                    <a href="index.html#!" class="dropdown-item active group gap-2.5">
                        <img src="/user/images/countries/US.png" class="size-5 rounded-full" alt="">
                        English
                        <span class="icon-[lucide--check] ml-auto hidden group-[.active]:block"></span>
                    </a>
                    <a href="index.html#!" class="dropdown-item group gap-2.5">
                        <img src="/user/images/countries/ES.png" class="size-5 rounded-full" alt="">
                        Espanol
                        <span class="icon-[lucide--check] ml-auto hidden group-[.active]:block"></span>
                    </a>
                    <a href="index.html#!" class="dropdown-item group gap-2.5">
                        <img src="/user/images/countries/JP.png" class="size-5 rounded-full" alt="">
                        Japanese
                        <span class="icon-[lucide--check] ml-auto hidden group-[.active]:block"></span>
                    </a>
                </div>
            </div> --}}

            <!--:Notifications:-->
            <div class="sm:relative">
                <button data-bs-auto-close="outside" type="button"
                    class="cursor-pointer relative flex items-center justify-center size-8 rounded-lg hover:bg-zinc-200 hover:text-black dark:hover:text-white dark:hover:bg-zinc-800 relative"
                    data-bs-toggle="dropdown" data-bs-display="static">
                    <span class="icon-[lucide--bell] text-lg"></span>
                    <!--:Notification badge with animation:-->
                    <span class="absolute right-1 top-1 flex size-2">
                        <span
                            class="absolute inline-flex h-full w-full animate-ping rounded-full bg-orange-400 opacity-75"></span>
                        <span class="relative inline-flex size-2 rounded-full bg-orange-500"></span>
                    </span>
                </button>
                <div
                    class="dropdown-menu absolute w-[94%] left-[3%] sm:w-96 abslute rtl:sm:left-0 ltr:sm:right-0 sm:left-auto top-full z-50 !p-0 mt-0.5 lg:mt-4.5 overflow-hidden">
                    <div class="px-3 pt-3 flex justify-between items-center">
                        <h5 class="text-lg">Notifications</h5>
                        @if ($userNotifications->count())
                            <button type="button" data-bs-toggle="tooltip" data-bs-placement="left"
                                data-bs-title="Mark all as read" class="hover:text-primary cursor-pointer">
                                {{ $userNotifications->count() }}
                            </button>
                        @endif
                    </div>
                    <div class="p-3 space-y-0.5 max-h-96 overflow-y-auto" data-simplebar>
                        <!--:Notification item:-->
                        @forelse($userNotifications as $note)
                            <a href="#"
                                class="px-3 py-2 gap-3 rounded-lg hover:bg-zinc-100 dark:hover:bg-zinc-700 flex">
                                <span
                                    class="size-8 rounded-full bg-sky-500/10 text-white flex items-center justify-center shrink-0">
                                    <span class="icon-[lucide--bell] text-lg"></span>
                                </span>
                                <div class="flex-grow">
                                    <div class="leading-normal">
                                        <span class="h5">{{ $note->type }}:</span>
                                        {{ $note->data['message'] ?? 'No message' }}
                                    </div>
                                    <small class="text-muted">{{ $note->created_at->diffForHumans() }}</small>
                                </div>
                            </a>
                        @empty
                            <div
                                class="flex flex-col items-center justify-center p-6 text-center text-gray-500 dark:text-gray-400">
                                <span class="icon-[lucide--bell] text-4xl mb-3"></span>
                                <p class="text-xl font-semibold">No Notification yet.</p>
                            </div>
                        @endforelse
                    </div>
                    {{-- <div class="px-4 py-2.5 text-center border-t border-zinc-100 dark:border-zinc-800">
                        <a href="index.html#!"
                            class="inline-block border-b border-dashed text-primary font-semibold hover:text-primary-deep text-sm">View
                            All</a>
                    </div> --}}
                </div>
            </div>

            <!--:Apps:-->
            {{-- <div class="lg:relative hidden lg:block">
                <button data-bs-auto-close="outside" type="button"
                    class="cursor-pointer relative flex items-center justify-center size-8 rounded-lg hover:bg-zinc-200 hover:text-black dark:hover:text-white dark:hover:bg-zinc-800"
                    data-bs-toggle="dropdown" data-bs-display="static">
                    <span class="icon-[lucide--component] text-lg"></span>
                </button>
                <div
                    class="dropdown-menu absolute w-56 abslute ltr:right-5 ltr:lg:right-0 rtl:lg:left-0 rtl:left-5 top-full z-50 !p-0 lg:mt-4.5">
                    <div class="flex flex-wrap p-2">
                        <div class="text-center w-1/2 p-2">
                            <a href="index.html#!"
                                class="p-2 rounded-lg hover:bg-zinc-100 dark:hover:bg-zinc-700 flex flex-col">
                                <img alt="" src="/user/images/brands/mailchimp.svg"
                                    class="h-6 w-auto block mx-auto mb-2">
                                <span>Mailchimp</span>
                            </a>
                        </div>
                        <div class="text-center w-1/2 p-2">
                            <a href="index.html#!"
                                class="p-2 rounded-lg hover:bg-zinc-100 dark:hover:bg-zinc-700 flex flex-col">
                                <img alt="" src="/user/images/brands/google-analytics.svg"
                                    class="h-6 w-auto block mx-auto mb-2">
                                <span class="truncate block">Analytics</span>
                            </a>
                        </div>
                        <div class="text-center w-1/2 p-2">
                            <a href="index.html#!"
                                class="p-2 rounded-lg hover:bg-zinc-100 dark:hover:bg-zinc-700 flex flex-col">
                                <img alt="" src="/user/images/brands/google-webdev.svg"
                                    class="h-6 w-auto block mx-auto mb-2">
                                <span>WebDev</span>
                            </a>
                        </div>
                        <div class="text-center w-1/2 p-2">
                            <a href="index.html#!"
                                class="p-2 rounded-lg hover:bg-zinc-100 dark:hover:bg-zinc-700 flex flex-col">
                                <img alt="" src="/user/images/brands/jira.svg"
                                    class="h-6 w-auto block mx-auto mb-2">
                                <span>Jira</span>
                            </a>
                        </div>
                        <div class="text-center w-1/2 p-2">
                            <a href="index.html#!"
                                class="p-2 rounded-lg hover:bg-zinc-100 dark:hover:bg-zinc-700 flex flex-col">
                                <img alt="" src="/user/images/brands/gitlab.svg"
                                    class="h-6 w-auto block mx-auto mb-2">
                                <span>Gitlab</span>
                            </a>
                        </div>
                        <div class="text-center w-1/2 p-2">
                            <a href="index.html#!"
                                class="p-2 rounded-lg hover:bg-zinc-100 dark:hover:bg-zinc-700 flex flex-col">
                                <img alt="" src="/user/images/brands/evernote.svg"
                                    class="h-6 w-auto block mx-auto mb-2">
                                <span>Evernote</span>
                            </a>
                        </div>
                    </div>
                    <div class="px-4 py-2.5 text-center border-t border-zinc-100 dark:border-zinc-800">
                        <a href="index.html#!"
                            class="inline-block border-b border-dashed text-primary font-semibold hover:text-primary-deep text-sm">View
                            All</a>
                    </div>
                </div>
            </div> --}}
            <!--:Theme color switcher:-->
            <div class="relative">
                <button type="button"
                    class="cursor-pointer relative flex items-center justify-center size-8 rounded-lg hover:bg-zinc-200 hover:text-black dark:hover:text-white dark:hover:bg-zinc-800"
                    data-bs-toggle="dropdown" data-bs-display="static" data-bs-auto-close="outside">
                    <img src="{{ asset('upload/profile/' . Auth::User()->image) }}" class="shrink-0 rounded-full"
                        alt="" style="height:25px; width:25px;">
                </button>
                <div class="dropdown-menu absolute min-w-56 abslute ltr:right-0 rtl:left-0 top-full z-50 !p-2 mt-4.5">
                    <div class="flex items-center gap-3.5 p-2 mb-2 rounded-lg bg-zinc-50 dark:bg-zinc-800">
                        <div class="flex-grow">
                            <p class="text-sm text-muted">Signed in as</p>
                            <p class="text-sm">{{ Auth::User()->firstname }}
                                {{ Auth::User()->lastname }}
                            </p>
                        </div>
                        <span class="shrink-0 pl-2">
                            <span class="icon-[solar--verified-check-bold] text-green-500"></span>
                        </span>
                    </div>

                    <div class="mb-1 px-1">
                        <h5>Balance: ${{ number_format(Auth::user()->balance, 2) }}</h5>
                    </div>

                    <div class="mb-1 px-1">
                        <h5>@php
                            $kyc = Auth::user()->kycVerification ?? null;
                        @endphp

                            @if (!$kyc)
                                <span
                                    class="badge bg-red-500/10 text-red-600 mt-1 mb-3 animate-pulse shadow-lg shadow-red-500/10">
                                    🔴 Unverified Account
                                </span>
                            @elseif ($kyc->status === 'Pending')
                                <span
                                    class="badge bg-amber-500/10 text-amber-600 mt-1 mb-3 animate-pulse shadow-lg shadow-amber-400/30">
                                    🕒 Pending Verification
                                </span>
                            @elseif ($kyc->status === 'Approved')
                                <span
                                    class="badge bg-green-500/10 text-green-600 mt-1 mb-3 shadow-md shadow-green-400/20">
                                    Verified Account
                                </span>
                            @else
                                <span
                                    class="badge bg-red-500/10 text-red-600 mt-1 mb-3 animate-pulse shadow-lg shadow-red-500/10">
                                    🔴 Unverified Account
                                </span>
                            @endif
                        </h5>
                    </div>
                    <a href="{{ url('user/profile') }}" class="dropdown-item">
                        <span class="dropdown-icon">
                            <span class="icon-[lucide--user]"></span>
                        </span>Profile</a>
                    <hr class="border-zinc-100 dark:border-zinc-800 my-2">
                    <form method="POST" action="{{ route('logout') }}">
                        @csrf
                        <a href="{{ route('logout') }}"
                            onclick="event.preventDefault(); this.closest('form').submit();" class="dropdown-item">
                            <span class="dropdown-icon">
                                <span class="icon-[lucide--log-out]"></span>
                            </span>Sign out</a>
                    </form>
                </div>
            </div>
        </div>
        <div class="collapse lg:ms-8 navbar-collapse w-full lg:flex-grow lg:w-auto lg:visible flex flex-wrap lg:justify-end items-center !visible lg:!flex lg:basis-auto basis-full lg:pt-0 lg:!bg-transparent"
            id="appNavbar">
            <div
                class="navbar-nav relative mt-2 lg:mt-0 flex flex-col lg:gap-4 gap-0.5 lg:flex-row lg:items-center bg-white dark:bg-zinc-950 lg:!bg-transparent w-full overflow-y-auto lg:overflow-visible lg:h-auto max-h-[80vh]">
                <div class="relative">
                    <a data-bs-display="static" data-bs-auto-close="outside" data-bs-toggle="dropdown"
                        href="index.html#" class="navbar-link ">
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>


<!--:Search Modal:-->
{{-- <div id="modal_search" role="dialog" class="modal fixed w-full h-full left-0 top-0 z-[60] hidden [&.show]:flex"
    tabindex="-1">
    <div class="modal-dialog relative m-4 pointer-events-none">
        <!--:Content:-->
        <div
            class="modal-content max-w-[30rem] mx-auto bg-white dark:bg-zinc-900 rounded-xl w-full pointer-events-auto">
            <div class="relative">
                <span
                    class="pointer-events-none text-base absolute rtl:right-3 ltr:left-3 top-1/2 -translate-y-1/2 opacity-50 leading-none">
                    <span class="icon-[lucide--search] text-lg"></span>
                </span>
                <button type="button"
                    class="absolute rtl:left-0 ltr:right-0 top-1/2 -translate-y-1/2 w-8 text-center me-3 cursor-pointer text-sm text-muted"
                    data-bs-dismiss="modal">
                    Esc
                </button>
                <input name="search" type="text"
                    class="w-full pl-4 !pl-9 !pr-10 py-2 h-12 focus:outline-0 rounded-t-xl border-0"
                    placeholder="Search..." autofocus />
            </div>
            <!--:Search results:-->
            <div class="border-t border-zinc-200 dark:border-zinc-800 max-h-[340px]" data-simplebar>
                <h5 class="mb-2 px-4 pt-4 text-muted">Recently Browses</h5>
                <ul class="flex flex-col pb-2">
                    <li
                        class="flex items-center gap-1 cursor-pointer hover:bg-zinc-50 dark:hover:bg-zinc-800 px-4 py-2">
                        <span class="bg-zinc-500 opacity-25 block size-1.5 me-1 rounded-full"></span>
                        <span>Apps</span>
                        <span class="icon-[lucide--chevron-right] opacity-50"></span>
                        <span>Api</span>
                    </li>
                    <li
                        class="flex items-center gap-1 cursor-pointer hover:bg-zinc-50 dark:hover:bg-zinc-800 px-4 py-2">
                        <span class="bg-zinc-500 opacity-25 block size-1.5 me-1 rounded-full"></span>
                        <span>Dashboard</span>
                        <span class="icon-[lucide--chevron-right] opacity-50"></span>
                        <span>Marketing</span>
                    </li>
                </ul>
                <hr class="border-zinc-200 dark:border-zinc-800">
                <h5 class="mb-2 px-4 pt-4 text-muted">Memebers</h5>
                <ul class="divide-y pb-2 px-4 divide-zinc-200 dark:divide-zinc-800 divide-dashed">
                    <li class="flex items-center py-3 justify-between gap-2.5">
                        <div class="flex items-center gap-2.5">
                            <div class="shrink-0">
                                <img alt="" class="h-8 rounded-full" src="/user/images/avatars/thumb-7.jpg">
                            </div>
                            <div class="flex flex-col gap-0.5">
                                <a class="flex items-center gap-1.5 leading-none h6 hover:!text-primary"
                                    href="index.html#">Ethan Smith</a>
                                <span class="text-sm text-muted">Backend Developer</span>
                            </div>
                        </div>
                    </li>

                    <li class="flex items-center py-3 justify-between gap-2.5">
                        <div class="flex items-center gap-2.5">
                            <div class="shrink-0">
                                <img alt="" class="h-8 rounded-full" src="/user/images/avatars/thumb-5.jpg">
                            </div>
                            <div class="flex flex-col gap-0.5">
                                <a class="flex items-center gap-1.5 leading-none h6 hover:!text-primary"
                                    href="index.html#">Isabella Garcia</a>
                                <span class="text-sm text-muted">Digital Marketer</span>
                            </div>
                        </div>
                    </li>

                    <li class="flex items-center py-3 justify-between gap-2.5">
                        <div class="flex items-center gap-2.5">
                            <div class="shrink-0">
                                <img alt="" class="h-8 rounded-full" src="/user/images/avatars/thumb-6.jpg">
                            </div>
                            <div class="flex flex-col gap-0.5">
                                <a class="flex items-center gap-1.5 leading-none h6 hover:!text-primary"
                                    href="index.html#">Noah Walker</a>
                                <span class="text-sm text-muted">Full Stack Developer</span>
                            </div>
                        </div>
                    </li>
                </ul>
                <hr class="border-zinc-200 dark:border-zinc-800">
                <h5 class="mb-2 px-4 pt-4 text-muted">Filters</h5>
                <ul class="flex flex-col pb-4">
                    <li
                        class="flex items-center gap-2 cursor-pointer hover:bg-zinc-50 dark:hover:bg-zinc-800 px-4 py-2">
                        <span class="badge bg-amber-500/20 text-amber-500">customers:</span>
                        <div class="flex-1 fs-10 title">All customers list</div>
                    </li>
                    <li
                        class="flex items-center gap-2 cursor-pointer hover:bg-zinc-50 dark:hover:bg-zinc-800 px-4 py-2">
                        <span class="badge bg-green-500/20 text-green-500">products:</span>
                        <div class="flex-1 fs-10 title">Bestselling products</div>
                    </li>
                    <li
                        class="flex items-center gap-2 cursor-pointer hover:bg-zinc-50 dark:hover:bg-zinc-800 px-4 py-2">
                        <span class="badge bg-sky-500/20 text-sky-500">events:</span>
                        <div class="flex-1 fs-10 title">All upcoming events</div>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div> --}}
