<x-user :title="$pageTitle">

    <!--:Page Header:-->
    <div class="px-4 lg:px-8 py-4">
        <h2 class="text-xl mb-2">Activity Log</h2>
        <!--:Breadcrumbs:-->
        <ol class="flex gap-1 items-center text-sm">
            <li class="flex items-center"><a href="index.html"
                    class="text-zinc-400 hover:text-zinc-700 dark:hover:text-white">Home</a></li>
            <li class="flex items-center opacity-30 leading-none">
                <span class="icon-[lucide--chevron-right] rtl:rotate-180"></span>
            </li>
            <li class="flex items-center"><span class="pointer-events-none">Account</span></li>
            <li class="flex items-center opacity-30 leading-none">
                <span class="icon-[lucide--chevron-right] rtl:rotate-180"></span>
            </li>
            <li class="flex items-center"><span class="pointer-events-none">Activity log</span></li>
        </ol>
    </div>

    <!--:Page content:-->
    <div class="content flex-grow px-2 lg:px-8 pt-6 mb-4 gap-2.5">
        <!--:Card:-->
        <div class="rounded-xl bg-white dark:bg-zinc-900 shadow-card border border-zinc-200 dark:border-zinc-800 mb-4">

            <div class="p-4 md:p-6 max-w-3xl mx-auto">
                <div class="mb-7 flex items-center justify-between">
                    <!--:Timeline:-->
                    <ul class="timeline">
                        @foreach($activity as $log)
                            <li class="timeline-item">
                                <div class="timeline-item-wrapper">
                                    <div class="timeline-item-media shrink-0">
                                        <div class="timeline-item-media-content">
                                            <!--:Avatar:-->
                                            <span
                                                class="inline-flex items-center justify-center w-10 h-10 rounded-md bg-blue-500/10 text-blue-600">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                                    viewBox="0 0 24 24">
                                                    <path fill="none" stroke="currentColor" stroke-linecap="round"
                                                        stroke-linejoin="round" stroke-width="2"
                                                        d="M22 12h-2.48a2 2 0 0 0-1.93 1.46l-2.35 8.36a.25.25 0 0 1-.48 0L9.24 2.18a.25.25 0 0 0-.48 0l-2.35 8.36A2 2 0 0 1 4.49 12H2" />
                                                </svg>
                                            </span>
                                        </div>
                                        <div class="timeline-connect"></div>
                                    </div>
                                    <div class="timeline-item-content">
                                        <div class="mt-1">
                                            <p class="mb-1"><span class="h6">{{ $log->activity_type }}: </span><span
                                                    class="text-green-500">
                                                    {{ $log->description }} </span>
                                                <span
                                                    class="block mt-1 text-xs text-muted">{{ $log->created_at->diffForHumans() }}</span>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </li>
                        @endforeach
                    </ul>

                </div>
            </div>
        </div>

</x-user>