<x-user :title="$pageTitle">

    <!--:Page Header:-->
    <div class="px-4 lg:px-8 py-4">
        <!--:Breadcrumbs:-->
        <ol class="flex gap-1 items-center text-sm">
            <li class="flex items-center"><a href="{{ url('user/bot_ai_trading') }}"
                    class="text-zinc-400 hover:text-zinc-700 dark:hover:text-white">Home</a></li>
            <li class="flex items-center opacity-30 leading-none">
                <span class="icon-[lucide--chevron-right] rtl:rotate-180"></span>
            </li>
            <li class="flex items-center"><span class="pointer-events-none">{{ $bot->name }}</span></li>
        </ol>
    </div>

    <!--:Page content:-->
    <div class="content flex-grow lg:px-4">
        <div class="px-2 py-4 max-w-7xl mx-auto">
            <div class="flex px-2 items-center gap-3.5">
                <div class="w-12 h-12 flex items-center justify-center bg-zinc-200 rounded-lg shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="55" height="55" viewBox="0 0 32 32">
                        <g fill="none">
                            <path fill="#f8312f"
                                d="M5 3.5a1.5 1.5 0 0 1-1 1.415V12l2.16 5.487L4 23c-1.1 0-2-.9-2-1.998v-7.004a2 2 0 0 1 1-1.728V4.915A1.5 1.5 0 1 1 5 3.5m25.05.05c0 .681-.44 1.26-1.05 1.468V12.2c.597.347 1 .994 1 1.73v7.01c0 1.1-.9 2-2 2l-2.94-5.68L28 11.93V5.018a1.55 1.55 0 1 1 2.05-1.468" />
                            <path fill="#ffb02e"
                                d="M11 4.5A1.5 1.5 0 0 1 12.5 3h7a1.5 1.5 0 0 1 .43 2.938c-.277.082-.57.104-.847.186l-3.053.904l-3.12-.908c-.272-.08-.56-.1-.832-.18A1.5 1.5 0 0 1 11 4.5" />
                            <path fill="#cdc4d6"
                                d="M22.05 30H9.95C6.66 30 4 27.34 4 24.05V12.03C4 8.7 6.7 6 10.03 6h11.95C25.3 6 28 8.7 28 12.03v12.03c0 3.28-2.66 5.94-5.95 5.94" />
                            <path fill="#212121"
                                d="M9.247 18.5h13.506c2.33 0 4.247-1.919 4.247-4.25A4.257 4.257 0 0 0 22.753 10H9.247A4.257 4.257 0 0 0 5 14.25a4.257 4.257 0 0 0 4.247 4.25m4.225 7.5h5.056C19.34 26 20 25.326 20 24.5s-.66-1.5-1.472-1.5h-5.056C12.66 23 12 23.674 12 24.5s.66 1.5 1.472 1.5" />
                            <path fill="#00a6ed"
                                d="M10.25 12C9.56 12 9 12.56 9 13.25v2.5a1.25 1.25 0 1 0 2.5 0v-2.5c0-.69-.56-1.25-1.25-1.25m11.5 0c-.69 0-1.25.56-1.25 1.25v2.5a1.25 1.25 0 1 0 2.5 0v-2.5c0-.69-.56-1.25-1.25-1.25" />
                        </g>
                    </svg>
                </div>
                <div class="flex-grow">
                    <h5 class="text-xl">{{ $bot->name }}</h5>
                    <span class="leading-none text-sm text-muted">{{ $bot->trading_type }}
                        Trading</span>
                </div>
                <div class="shrink-0">
                    <span class="ms-auto"
                        style="display:inline-flex;align-items:center;gap:6px;font-weight:600;font-family:sans-serif;">
                        <span style="
                                    position:relative;
                                    width:10px;height:10px;
                                    border-radius:50%;
                                    background:#22c55e;
                                    display:inline-block;
                                    animation:pulse 1.4s infinite;
                                "></span>
                        <span class="ms-auto badge bg-sky-500/10 text-white">Active</span>
                    </span>
                </div>
            </div>
            <p class="mb-4 px-2 mt-3">
                {{ $bot->description }}
            </p>

            <hr class="border-zinc-200 dark:border-zinc-800 border-dashed my-5">
            <div class="px-2">
                <div class="grid grid-cols-1 lg:grid-cols-12 mb-4 gap-4">
                    <div class="lg:col-span-8">
                        <!--:Project card:-->
                        <div
                            class="rounded-md shadow-card p-4 mb-4 border-zinc-200 dark:border-zinc-800 border relative">
                            {{-- <div class="flex items-center gap-3.5">
                                <div class="w-12 h-12 flex items-center justify-center bg-zinc-200 rounded-lg shrink-0">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="55" height="55" viewBox="0 0 32 32">
                                        <g fill="none">
                                            <path fill="#f8312f"
                                                d="M5 3.5a1.5 1.5 0 0 1-1 1.415V12l2.16 5.487L4 23c-1.1 0-2-.9-2-1.998v-7.004a2 2 0 0 1 1-1.728V4.915A1.5 1.5 0 1 1 5 3.5m25.05.05c0 .681-.44 1.26-1.05 1.468V12.2c.597.347 1 .994 1 1.73v7.01c0 1.1-.9 2-2 2l-2.94-5.68L28 11.93V5.018a1.55 1.55 0 1 1 2.05-1.468" />
                                            <path fill="#ffb02e"
                                                d="M11 4.5A1.5 1.5 0 0 1 12.5 3h7a1.5 1.5 0 0 1 .43 2.938c-.277.082-.57.104-.847.186l-3.053.904l-3.12-.908c-.272-.08-.56-.1-.832-.18A1.5 1.5 0 0 1 11 4.5" />
                                            <path fill="#cdc4d6"
                                                d="M22.05 30H9.95C6.66 30 4 27.34 4 24.05V12.03C4 8.7 6.7 6 10.03 6h11.95C25.3 6 28 8.7 28 12.03v12.03c0 3.28-2.66 5.94-5.95 5.94" />
                                            <path fill="#212121"
                                                d="M9.247 18.5h13.506c2.33 0 4.247-1.919 4.247-4.25A4.257 4.257 0 0 0 22.753 10H9.247A4.257 4.257 0 0 0 5 14.25a4.257 4.257 0 0 0 4.247 4.25m4.225 7.5h5.056C19.34 26 20 25.326 20 24.5s-.66-1.5-1.472-1.5h-5.056C12.66 23 12 23.674 12 24.5s.66 1.5 1.472 1.5" />
                                            <path fill="#00a6ed"
                                                d="M10.25 12C9.56 12 9 12.56 9 13.25v2.5a1.25 1.25 0 1 0 2.5 0v-2.5c0-.69-.56-1.25-1.25-1.25m11.5 0c-.69 0-1.25.56-1.25 1.25v2.5a1.25 1.25 0 1 0 2.5 0v-2.5c0-.69-.56-1.25-1.25-1.25" />
                                        </g>
                                    </svg>
                                </div>
                                <div class="flex-grow">
                                    <h5 class="text-xl">{{ $bot->name }}</h5>
                                    <span class="leading-none text-sm text-muted">{{ $bot->trading_type }}
                                        Trading</span>
                                </div>
                                <div class="shrink-0">
                                    <span class="ms-auto"
                                        style="display:inline-flex;align-items:center;gap:6px;font-weight:600;font-family:sans-serif;">
                                        <span style="
                                    position:relative;
                                    width:10px;height:10px;
                                    border-radius:50%;
                                    background:#22c55e;
                                    display:inline-block;
                                    animation:pulse 1.4s infinite;
                                "></span>
                                        <span class="ms-auto badge bg-sky-500/10 text-white">Active</span>
                                    </span>
                                </div>
                            </div>
                            <p class="mb-4 mt-3">
                                {{ $bot->description }}
                            </p>

                            <hr class="border-zinc-200 dark:border-zinc-800 border-dashed my-5"> --}}
                            <h6 class="text-lg mb-4">Performance</h6>
                            <div class="grid gap-2 grid-cols-2 md:grid-cols-3 lg:grid-cols-4">
                                <div class="flex flex-col gap-2 rounded-lg py-2 text-center bg-white dark:bg-zinc-900">
                                    <h6>{{ $bot->success_rate }}%</h6>
                                    <small class="text-muted">Success Rate</small>
                                </div>
                                <div class="flex flex-col gap-2 rounded-lg py-2 text-center bg-white dark:bg-zinc-900">
                                    <h6>{{ $bot->total_trades }}</h6>
                                    <small class="text-muted">Total Trades</small>
                                </div>
                                <div class="flex flex-col gap-2 rounded-lg py-2 text-center bg-white dark:bg-zinc-900">
                                    <h6>{{ $bot->duration_days }} Days</h6>
                                    <small class="text-muted">Duration</small>
                                </div>
                                <div class="flex flex-col gap-2 rounded-lg py-2 text-center bg-white dark:bg-zinc-900">
                                    <h6>{{ $bot->bots_profit }}%</h6>
                                    <small class="text-muted">Daily Returns</small>
                                </div>
                            </div>
                        </div>
                        <!--:Card:-->
                        <div class="rounded-md border-zinc-200 dark:border-zinc-800 border p-5">
                            <div class="px-4 pt-4 flex items-center justify-between">
                                <h5 class="text-lg">Trading Strategy</h5>
                            </div>
                            <div class="p-4">
                                <div class="grid gap-2 grid-cols-2 md:grid-cols-2 lg:grid-cols-2">
                                    <!-- Strategy Type -->
                                    <div class="flex flex-col gap-2 rounded-md py-4 px-3 bg-white dark:bg-zinc-900">
                                        <h6
                                            class="flex items-center gap-2 text-sm font-medium text-gray-800 dark:text-gray-200">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"
                                                viewBox="0 0 23 32">
                                                <g fill="currentColor">
                                                    <path
                                                        d="M22 31.5a.5.5 0 0 0-.5-.5h-18a.5.5 0 0 0 0 1h18a.5.5 0 0 0 .5-.5M1.274 9.354C.856 9.632.222 10.478.823 11.68c.499.997 1.54 2.217 2.647 2.539a1.96 1.96 0 0 0 1.605-.196c1.099-.658 2.397-1.548 2.947-1.93c.694.351 1.57.424 2.46.195l.012-.004c-.052 1.651-.611 2.682-3.344 5.22c-2.436 2.261-3.881 5.231-3.867 7.946c.01 1.781.659 3.31 1.88 4.419A.5.5 0 0 0 5.5 30h14a.5.5 0 0 0 0-1H5.699c-.919-.905-1.407-2.13-1.415-3.555c-.013-2.402 1.347-5.165 3.547-7.208C10.746 15.531 11.5 14.249 11.5 12c0-.041-.014-.077-.023-.115c.547-.295 1.02-.685 1.343-1.157c.405-.59 1.277-2.105.63-3.446a.5.5 0 1 0-.9.436c.291.603.084 1.517-.554 2.445c-.368.536-1.026.969-1.761 1.157c-.747.191-1.457.107-1.952-.232a.5.5 0 0 0-.571.004c-.018.012-1.777 1.251-3.149 2.074a.97.97 0 0 1-.812.094c-.774-.226-1.625-1.212-2.032-2.026c-.329-.658.008-.972.161-1.084c3.447-2.977 5.177-6.07 5.248-6.201a.5.5 0 0 0 .036-.399a20 20 0 0 1-.54-2.033c1.046.63 2.845 1.51 4.718 1.51c2.604 0 8.658.972 8.658 9.976c0 .049-.009 4.944-1.97 10.327a.5.5 0 1 0 .94.341C20.991 18.123 21.001 13.205 21 13c0-10.183-7.393-10.974-9.658-10.974C8.833 2.026 6.33.123 6.306.103a.51.51 0 0 0-.527-.051A.5.5 0 0 0 5.5.5c0 .981.465 2.568.646 3.147c-.418.698-2.066 3.281-4.872 5.707" />
                                                    <path
                                                        d="M17.485 1.54C15.884.461 14.094 0 11.5 0a.5.5 0 0 0 0 1c2.38 0 4.003.409 5.427 1.369C19.241 3.931 22 7.043 22 13c0 1.451 0 3.438-.985 7.379a.5.5 0 0 0 .97.242C23 16.562 23 14.503 23 13c0-6.396-2.999-9.763-5.515-11.46" />
                                                </g>
                                            </svg>
                                            Strategy Type
                                        </h6>
                                        <p class="text-muted text-md">{{ $bot->strategy_type }}</p>
                                    </div>

                                    <!-- Trading Frequency -->
                                    <div class="flex flex-col gap-2 rounded-md py-4 px-3 bg-white dark:bg-zinc-900">
                                        <h6
                                            class="flex items-center gap-2 text-md font-medium text-gray-800 dark:text-gray-200">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                viewBox="0 0 24 24">
                                                <path fill="currentColor" fill-rule="evenodd"
                                                    d="m12.6 11.503l3.891 3.891l-.848.849L11.4 12V6h1.2zM12 22C6.477 22 2 17.523 2 12S6.477 2 12 2s10 4.477 10 10s-4.477 10-10 10m0-1.2a8.8 8.8 0 1 0 0-17.6a8.8 8.8 0 0 0 0 17.6" />
                                            </svg>
                                            Trading Frequency
                                        </h6>
                                        <p class="text-muted text-md">{{ $bot->trading_frequency }}</p>
                                    </div>
                                </div>
                            </div>

                            <div class="p-4">
                                <div class="gap-2">
                                    <div class="flex flex-col gap-2 rounded-md py-4 px-3 bg-white dark:bg-zinc-900">
                                        <h6
                                            class="flex items-center gap-2 text-md font-medium text-gray-800 dark:text-gray-200">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                                viewBox="0 0 24 24">
                                                <g fill="none">
                                                    <path
                                                        d="m12.593 23.258l-.011.002l-.071.035l-.02.004l-.014-.004l-.071-.035q-.016-.005-.024.005l-.004.01l-.017.428l.005.02l.01.013l.104.074l.015.004l.012-.004l.104-.074l.012-.016l.004-.017l-.017-.427q-.004-.016-.017-.018m.265-.113l-.013.002l-.185.093l-.01.01l-.003.011l.018.43l.005.012l.008.007l.201.093q.019.005.029-.008l.004-.014l-.034-.614q-.005-.018-.02-.022m-.715.002a.02.02 0 0 0-.027.006l-.006.014l-.034.614q.001.018.017.024l.015-.002l.201-.093l.01-.008l.004-.011l.017-.43l-.003-.012l-.01-.01z" />
                                                    <path fill="currentColor"
                                                        d="M12 2c5.523 0 10 4.477 10 10s-4.477 10-10 10S2 17.523 2 12S6.477 2 12 2m0 2a8 8 0 1 0 0 16a8 8 0 0 0 0-16m-.01 6c.558 0 1.01.452 1.01 1.01v5.124A1 1 0 0 1 12.5 18h-.49A1.01 1.01 0 0 1 11 16.99V12a1 1 0 1 1 0-2zM12 7a1 1 0 1 1 0 2a1 1 0 0 1 0-2" />
                                                </g>
                                            </svg>Description
                                        </h6>
                                        <p class="text-md text-muted">{{ $bot->description }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="lg:col-span-4">

                        @if ($userTrade)
                            <div class="divide-dashed divide-y divide-zinc-500/10 dark:divide-zinc-800 overflow-hidden border-zinc-200 dark:border-zinc-800 border rounded-md shadow-card mb-4"
                                id="task-board">

                                <div class="mb-2 pb-2 parent-task group">
                                    <div class="flex items-center justify-between px-4 pt-4 pb-2.5">
                                        <h5 class="text-lg">Investment Details</h5>
                                    </div>

                                    <ul class="divide-y px-4 divide-zinc-500/10 dark:divide-zinc-800 child-list w-full">
                                        <!-- Min Amount -->
                                        <li class="flex items-start py-2.5 child-task w-full">
                                            <div class="flex items-center flex-grow px-3">
                                                <label>Minimum Amount:</label>
                                            </div>
                                            <div class="flex items-center space-x-2 text-sm shrink-0">
                                                <p class="text-md font-semibold">${{ number_format($bot->min_amount, 2) }}</p>
                                            </div>
                                        </li>

                                        <!-- Max Amount -->
                                        <li class="flex items-start py-2.5 child-task w-full">
                                            <div class="flex items-center flex-grow px-3">
                                                <label>Maximum Amount:</label>
                                            </div>
                                            <div class="flex items-center space-x-2 text-sm shrink-0">
                                                <p class="text-md font-semibold">${{ number_format($bot->max_amount, 2) }}</p>
                                            </div>
                                        </li>

                                        <!-- ROI -->
                                        <li class="flex items-start py-2.5 child-task w-full">
                                            <div class="flex items-center flex-grow px-3">
                                                <label>Expected ROI:</label>
                                            </div>
                                            <div class="flex items-center space-x-2 text-sm shrink-0">
                                                <p class="text-md font-semibold text-green-500">{{ $bot->expected_returns }}</p>
                                            </div>
                                        </li>

                                        <!-- User Investment Details -->
                                        <div
                                            class="divide-dashed divide-y mt-3 border-zinc-200 dark:border-zinc-700 border divide-zinc-500/10 dark:divide-zinc-800 overflow-hidden rounded-xl bg-white dark:bg-zinc-900 shadow-card">
                                            <div class="flex items-center justify-between px-4 gap-2 pt-4 pb-2.5">
                                                <div class="w-8 h-8 flex items-center justify-center bg-primary-subtle rounded-lg shrink-0">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                                                        <path fill="currentColor"
                                                            d="M4 4a2 2 0 0 1 2-2h8a1 1 0 0 1 .707.293l5 5A1 1 0 0 1 20 8v12a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2zm13.586 4L14 4.414V8zM12 4H6v16h12V10h-5a1 1 0 0 1-1-1zm-4 9a1 1 0 0 1 1-1h6a1 1 0 1 1 0 2H9a1 1 0 0 1-1-1m0 4a1 1 0 0 1 1-1h6a1 1 0 1 1 0 2H9a1 1 0 0 1-1-1" />
                                                    </svg>
                                                </div>
                                                <h5 class="text-md">Your Investment</h5>
                                            </div>

                                            <ul class="divide-y px-4 divide-zinc-500/10 dark:divide-zinc-800 child-list w-full">
                                                <li class="flex items-start py-2.5 child-task w-full">
                                                    <div class="flex items-center flex-grow px-3">
                                                        <label>Amount Invested:</label>
                                                    </div>
                                                    <div class="flex items-center space-x-2 text-sm shrink-0">
                                                        <p class="text-md font-semibold">${{ number_format($userTrade->amount_invested, 2) }}</p>
                                                    </div>
                                                </li>

                                                @php
                                                    $isProfit = $userTrade->current_value > $userTrade->amount_invested;
                                                @endphp

                                                <li class="flex items-start py-2.5 child-task w-full">
                                                    <div class="flex items-center flex-grow px-3">
                                                        <label>Current P/L:</label>
                                                    </div>
                                                    <div class="flex items-center space-x-2 text-sm shrink-0">
                                                        <p class="text-md font-semibold {{ $isProfit ? 'text-green-500' : 'text-red-500' }}">
                                                            ${{ number_format($userTrade->profit_earned, 2) }}
                                                        </p>
                                                    </div>
                                                </li>

                                                <li class="flex items-start py-2.5 child-task w-full">
                                                    <div class="flex items-center flex-grow px-3">
                                                        <label>Total Value:</label>
                                                    </div>
                                                    <div class="flex items-center space-x-2 text-sm shrink-0">
                                                        <p class="text-md font-semibold text-primary">
                                                            ${{ number_format($userTrade->current_value, 2) }}
                                                        </p>
                                                    </div>
                                                </li>

                                                <li class="flex items-start py-2.5 child-task w-full">
                                                    <div class="flex items-center flex-grow px-3">
                                                        <label>Status:</label>
                                                    </div>
                                                    <div class="flex items-center space-x-2 text-sm shrink-0">
                                                        <span class="px-2 py-1 rounded text-xs font-semibold
                                                                @if ($userTrade->status === 'running') bg-green-500/10 text-green-700
                                                                @elseif ($userTrade->status === 'completed') bg-blue-100 text-blue-700
                                                                @elseif ($userTrade->status === 'cancelled') bg-red-100 text-red-700
                                                                @else bg-gray-100 text-gray-700 @endif">
                                                            {{ ucfirst($userTrade->status) }}
                                                        </span>
                                                    </div>
                                                </li>

                                                <li class="flex items-start py-2.5 child-task w-full">
                                                    <div class="flex items-center flex-grow px-3">
                                                        <label>Started On:</label>
                                                    </div>
                                                    <div class="flex items-center space-x-2 text-sm shrink-0">
                                                        <p class="text-md font-semibold text-gray-700 dark:text-gray-300">
                                                            {{ $userTrade->created_at->format('M d, Y') }}
                                                        </p>
                                                    </div>
                                                </li>

                                                {{-- ✅ Conditional Button --}}
                                                @if ($userTrade->status === 'running')
                                                    <form method="POST" action="{{ route('userbots.stopbybot', $bot->name) }}">
                                                        @csrf
                                                        <li>
                                                            <button type="submit"
                                                                class="w-full rounded-md mb-2 mt-2 h-9 bg-red-500 text-white font-semibold flex items-center justify-center gap-2">
                                                                Cancel Investment
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24">
                                                                    <path fill="currentColor"
                                                                        d="M14 9a.5.5 0 0 1 .5-.5H18a.5.5 0 0 1 .5.5v3.5a.5.5 0 0 1-1 0v-2.293l-5.146 5.147a.5.5 0 0 1-.708 0L9 12.707l-2.646 2.647a.5.5 0 0 1-.708-.708l3-3a.5.5 0 0 1 .708 0L12 14.293L16.793 9.5H14.5A.5.5 0 0 1 14 9" />
                                                                </svg>
                                                            </button>
                                                        </li>
                                                    </form>
                                                @else
                                                    <form method="POST" action="{{ route('userbots.start', $bot->name) }}">
                                                        @csrf
                                                        <li class="flex flex-col py-2.5 child-task w-full">
                                                            <div class="w-full px-2 mb-4">
                                                                <label class="mb-1 block">Investment Amount</label>
                                                                <div class="relative">
                                                                    <span
                                                                        class="absolute left-4 top-1/2 -translate-y-1/2 pointer-events-none opacity-75">$</span>
                                                                    <input type="text" name="amount" class="input !pl-7 mt-2 w-full" required
                                                                        min="{{ $bot->min_amount }}" max="{{ $bot->max_amount }}"
                                                                        value="{{ old('amount') }}">
                                                                </div>
                                                            </div>
                                                            <button type="submit"
                                                                class="w-full rounded-md mb-2 mt-2 h-9 bg-primary text-white flex items-center justify-center gap-2">
                                                                Invest Again
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24">
                                                                    <path fill="currentColor"
                                                                        d="M14 9a.5.5 0 0 1 .5-.5H18a.5.5 0 0 1 .5.5v3.5a.5.5 0 0 1-1 0v-2.293l-5.146 5.147a.5.5 0 0 1-.708 0L9 12.707l-2.646 2.647a.5.5 0 0 1-.708-.708l3-3a.5.5 0 0 1 .708 0L12 14.293L16.793 9.5H14.5A.5.5 0 0 1 14 9" />
                                                                </svg>
                                                            </button>
                                                        </li>
                                                    </form>
                                                @endif
                                            </ul>
                                        </div>
                                    </ul>
                                </div>
                            </div>
                        @else
                            <!-- Parent Task -->
                            <div class="divide-dashed divide-y divide-zinc-500/10 dark:divide-zinc-800 overflow-hidden border-zinc-200 dark:border-zinc-800 border rounded-md shadow-card mb-4"
                                id="task-board">
                                <!-- Parent Task -->
                                <div class="mb-2 pb-2 parent-task group">
                                    <div class="flex items-center justify-between px-4 pt-4 pb-2.5">
                                        <div class="flex items-center">
                                            <h5 class="text-lg">Investment Details</h5>
                                        </div>
                                    </div>

                                    <!-- ✅ Fixed Child Tasks List -->
                                    <ul class="divide-y px-4 divide-zinc-500/10 dark:divide-zinc-800 child-list w-full">
                                        <!--:Child task item:-->
                                        <li class="flex items-start py-2.5 child-task w-full">
                                            <div class="flex items-center flex-grow px-3">
                                                <label>Minimum Amount:</label>
                                            </div>
                                            <div class="flex items-center space-x-2 text-sm shrink-0">
                                                <p class="text-md font-semibold">
                                                    ${{ number_format($bot->min_amount, 2) }}
                                                </p>
                                            </div>
                                        </li>

                                        <li class="flex items-start py-2.5 child-task w-full">
                                            <div class="flex items-center flex-grow px-3">
                                                <label>Maximum Amount:</label>
                                            </div>
                                            <div class="flex items-center space-x-2 text-sm shrink-0">
                                                <p class="text-md font-semibold">
                                                    ${{ number_format($bot->max_amount, 2) }}
                                                </p>
                                            </div>
                                        </li>

                                        <li class="flex items-start py-2.5 child-task w-full">
                                            <div class="flex items-center flex-grow px-3">
                                                <label>Expected ROI</label>
                                            </div>
                                            <div class="flex items-center space-x-2 text-sm shrink-0">
                                                <p class="text-md font-semibold text-green-500">
                                                    {{ $bot->expected_returns }}
                                                </p>
                                            </div>
                                        </li>

                                        <form method="POST" action="{{ route('userbots.start', $bot->name) }}">
                                            @csrf
                                            <li class="flex flex-col py-2.5 child-task w-full">
                                                <div class="w-full px-2 mb-4">
                                                    <label class="mb-1 block">Investment Amount</label>
                                                    <div class="relative">
                                                        <span
                                                            class="absolute left-4 top-1/2 -translate-y-1/2 pointer-events-none opacity-75">$</span>
                                                        <input type="text" name="amount" class="input !pl-7 mt-2 w-full" required
                                                            min="{{ $bot->min_amount }}" max="{{ $bot->max_amount }}" value="{{ old('amount') }}">
                                                    </div>

                                                    @error('amount')
                                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                                    @enderror

                                                    <div class="flex flex-wrap items-center justify-between py-2.5 text-sm">
                                                        <div class="flex items-center px-3">
                                                            <p class="text-md font-semibold">
                                                                Min: ${{ number_format($bot->min_amount, 2) }}
                                                            </p>
                                                        </div>
                                                        <div class="flex items-center px-3">
                                                            <p class="text-md font-semibold">
                                                                Max: ${{ number_format($bot->max_amount, 2) }}
                                                            </p>
                                                        </div>
                                                    </div>

                                                    <div class="mb-4 mt-2 text-sm text-zinc-600 dark:text-zinc-400">
                                                        This bot runs for <strong>{{ $bot->duration_days }}
                                                            days</strong>
                                                        and
                                                        generates approximately
                                                        <strong>{{ $bot->bots_profit }}%</strong> profit daily.
                                                    </div>
                                                </div>
                                            </li>
                                            <li>
                                                <button type="submit"
                                                    class="w-full rounded-md mt-2 h-9 bg-primary text-white flex items-center justify-center gap-2">
                                                    Invest Now
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                                        <path fill="currentColor"
                                                            d="M14 9a.5.5 0 0 1 .5-.5H18a.5.5 0 0 1 .5.5v3.5a.5.5 0 0 1-1 0v-2.293l-5.146 5.147a.5.5 0 0 1-.708 0L9 12.707l-2.646 2.647a.5.5 0 0 1-.708-.708l3-3a.5.5 0 0 1 .708 0L12 14.293L16.793 9.5H14.5A.5.5 0 0 1 14 9" />
                                                    </svg>
                                                </button>
                                            </li>
                                        </form>
                                    </ul>
                                </div>
                            </div>
                        @endif


                        <!--:Tasks:-->
                        {{-- @if ($userTrade)
                            <div class="divide-dashed divide-y divide-zinc-500/10 dark:divide-zinc-800 overflow-hidden border-zinc-200 dark:border-zinc-800 border rounded-md shadow-card mb-4"
                                id="task-board">
                                <!-- Parent Task -->
                                <div class="mb-2 pb-2 parent-task group">
                                    <div class="flex items-center justify-between px-4 pt-4 pb-2.5">
                                        <div class="flex items-center">
                                            <h5 class="text-lg">Investment Details</h5>
                                        </div>
                                    </div>

                                    <!-- ✅ Fixed Child Tasks List -->
                                    <ul class="divide-y px-4 divide-zinc-500/10 dark:divide-zinc-800 child-list w-full">
                                        <!--:Child task item:-->
                                        <li class="flex items-start py-2.5 child-task w-full">
                                            <div class="flex items-center flex-grow px-3">
                                                <label>Minimum Amount:</label>
                                            </div>
                                            <div class="flex items-center space-x-2 text-sm shrink-0">
                                                <p class="text-md font-semibold">
                                                    ${{ number_format($bot->min_amount, 2) }}
                                                </p>
                                            </div>
                                        </li>

                                        <li class="flex items-start py-2.5 child-task w-full">
                                            <div class="flex items-center flex-grow px-3">
                                                <label>Maximum Amount:</label>
                                            </div>
                                            <div class="flex items-center space-x-2 text-sm shrink-0">
                                                <p class="text-md font-semibold">
                                                    ${{ number_format($bot->max_amount, 2) }}
                                                </p>
                                            </div>
                                        </li>

                                        <li class="flex items-start py-2.5 child-task w-full">
                                            <div class="flex items-center flex-grow px-3">
                                                <label>Expected ROI</label>
                                            </div>
                                            <div class="flex items-center space-x-2 text-sm shrink-0">
                                                <p class="text-md font-semibold text-green-500">
                                                    {{ $bot->expected_returns }}
                                                </p>
                                            </div>
                                        </li>
                                        <div class="divide-dashed divide-y mt-3 border-zinc-200 dark:border-zinc-700 border divide-zinc-500/10 dark:divide-zinc-800 overflow-hidden rounded-xl bg-white dark:bg-zinc-900 shadow-card"
                                            id="task-board">
                                            <!-- Parent Task -->
                                            <div class="mb-2 pb-2 parent-task group">
                                                <div class="flex items-center justify-between px-4 gap-2 pt-4 pb-2.5">
                                                    <div
                                                        class="w-8 h-8 flex items-center justify-center bg-primary-subtle rounded-lg shrink-0">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                                            viewBox="0 0 24 24">
                                                            <path fill="currentColor"
                                                                d="M4 4a2 2 0 0 1 2-2h8a1 1 0 0 1 .707.293l5 5A1 1 0 0 1 20 8v12a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2zm13.586 4L14 4.414V8zM12 4H6v16h12V10h-5a1 1 0 0 1-1-1zm-4 9a1 1 0 0 1 1-1h6a1 1 0 1 1 0 2H9a1 1 0 0 1-1-1m0 4a1 1 0 0 1 1-1h6a1 1 0 1 1 0 2H9a1 1 0 0 1-1-1" />
                                                        </svg>
                                                    </div>
                                                    <div class="flex-grow">
                                                        <h5 class="text-md">Your Investment</h5>
                                                    </div>
                                                </div>
                                                <ul
                                                    class="divide-y px-4 divide-zinc-500/10 dark:divide-zinc-800 child-list w-full">
                                                    <!--:Child task item:-->
                                                    <li class="flex items-start py-2.5 child-task w-full">
                                                        <div class="flex items-center flex-grow px-3">
                                                            <label>Amount Investment:</label>
                                                        </div>
                                                        <div class="flex items-center space-x-2 text-sm shrink-0">
                                                            <p class="text-md font-semibold">
                                                                ${{ number_format($userTrade->amount_invested, 2) }}
                                                            </p>
                                                        </div>
                                                    </li>
                                                    @php
    $isProfit =
        $userTrade->current_value > $userTrade->amount_invested;
                                                    @endphp
                                                    <li class="flex items-start py-2.5 child-task w-full">
                                                        <div class="flex items-center flex-grow px-3">
                                                            <label>Current P/L:</label>
                                                        </div>
                                                        <div class="flex items-center space-x-2 text-sm shrink-0">
                                                            <p
                                                                class="text-md font-semibold {{ $isProfit ? 'text-green-500' : 'text-red-500' }}">
                                                                ${{ number_format($userTrade->profit_earned, 2) }}
                                                            </p>
                                                        </div>
                                                    </li>

                                                    <!-- Total Value -->
                                                    <li class="flex items-start py-2.5 child-task w-full">
                                                        <div class="flex items-center flex-grow px-3">
                                                            <label class="text-gray-500 dark:text-gray-400">Total
                                                                Value:</label>
                                                        </div>
                                                        <div class="flex items-center space-x-2 text-sm shrink-0">
                                                            <p class="text-md font-semibold text-primary">
                                                                ${{ number_format($userTrade->current_value, 2) }}
                                                            </p>
                                                        </div>
                                                    </li>

                                                    <!-- Status -->
                                                    <li class="flex items-start py-2.5 child-task w-full">
                                                        <div class="flex items-center flex-grow px-3">
                                                            <label class="text-gray-500 dark:text-gray-400">Status:</label>
                                                        </div>
                                                        <div class="flex items-center space-x-2 text-sm shrink-0">
                                                            <span
                                                                class="px-2 py-1 rounded text-xs font-semibold
                                                                                                    @if ($userTrade->status === 'running') bg-primary-subtle text-green-700
                                                                                                    @elseif ($userTrade->status === 'completed') bg-green-500/20 text-blue-700
                                                                                                    @elseif ($userTrade->status === 'cancel') bg-red-500/20 text-red-700
                                                                                                    @else bg-gray-100 text-gray-700 @endif">
                                                                {{ ucfirst($userTrade->status) }}
                                                            </span>
                                                        </div>
                                                    </li>

                                                    <!-- Started On -->
                                                    <li class="flex items-start py-2.5 child-task w-full">
                                                        <div class="flex items-center flex-grow px-3">
                                                            <label class="text-gray-500 dark:text-gray-400">Started
                                                                On:</label>
                                                        </div>
                                                        <div class="flex items-center space-x-2 text-sm shrink-0">
                                                            <p
                                                                class="text-md font-semibold text-gray-700 dark:text-gray-300">
                                                                {{ $userTrade->created_at->format('M d, Y') }}
                                                            </p>
                                                        </div>
                                                    </li>

                                                    <form method="POST"
                                                        action="{{ route('userbots.stopbybot', $bot->name) }}">
                                                        @csrf
                                                        <li>
                                                            <button type="submit"
                                                                class="w-full rounded-md mt-2 h-9 bg-red-500 text-white flex items-center justify-center gap-2">
                                                                Cancel Investment
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="24"
                                                                    height="24" viewBox="0 0 24 24">
                                                                    <path fill="currentColor"
                                                                        d="M14 9a.5.5 0 0 1 .5-.5H18a.5.5 0 0 1 .5.5v3.5a.5.5 0 0 1-1 0v-2.293l-5.146 5.147a.5.5 0 0 1-.708 0L9 12.707l-2.646 2.647a.5.5 0 0 1-.708-.708l3-3a.5.5 0 0 1 .708 0L12 14.293L16.793 9.5H14.5A.5.5 0 0 1 14 9" />
                                                                </svg>
                                                            </button>
                                                        </li>
                                                    </form>
                                                </ul>
                                            </div>
                                        </div>
                                    </ul>
                                </div>
                            </div>
                        @else
                            <!--:Tasks:-->
                            <div class="divide-dashed divide-y divide-zinc-500/10 dark:divide-zinc-800 overflow-hidden border-zinc-200 dark:border-zinc-800 border rounded-md shadow-card mb-4"
                                id="task-board">
                                <!-- Parent Task -->
                                <div class="mb-2 pb-2 parent-task group">
                                    <div class="flex items-center justify-between px-4 pt-4 pb-2.5">
                                        <div class="flex items-center">
                                            <h5 class="text-lg">Investment Details</h5>
                                        </div>
                                    </div>

                                    <!-- ✅ Fixed Child Tasks List -->
                                    <ul class="divide-y px-4 divide-zinc-500/10 dark:divide-zinc-800 child-list w-full">
                                        <!--:Child task item:-->
                                        <li class="flex items-start py-2.5 child-task w-full">
                                            <div class="flex items-center flex-grow px-3">
                                                <label>Minimum Amount:</label>
                                            </div>
                                            <div class="flex items-center space-x-2 text-sm shrink-0">
                                                <p class="text-md font-semibold">
                                                    ${{ number_format($bot->min_amount, 2) }}
                                                </p>
                                            </div>
                                        </li>

                                        <li class="flex items-start py-2.5 child-task w-full">
                                            <div class="flex items-center flex-grow px-3">
                                                <label>Maximum Amount:</label>
                                            </div>
                                            <div class="flex items-center space-x-2 text-sm shrink-0">
                                                <p class="text-md font-semibold">
                                                    ${{ number_format($bot->max_amount, 2) }}
                                                </p>
                                            </div>
                                        </li>

                                        <li class="flex items-start py-2.5 child-task w-full">
                                            <div class="flex items-center flex-grow px-3">
                                                <label>Expected ROI</label>
                                            </div>
                                            <div class="flex items-center space-x-2 text-sm shrink-0">
                                                <p class="text-md font-semibold text-green-500">
                                                    {{ $bot->expected_returns }}
                                                </p>
                                            </div>
                                        </li>

                                        <form method="POST" action="{{ route('userbots.start', $bot->name) }}">
                                            @csrf
                                            <li class="flex flex-col py-2.5 child-task w-full">
                                                <div class="w-full px-2 mb-4">
                                                    <label class="mb-1 block">Investment Amount</label>
                                                    <div class="relative">
                                                        <span
                                                            class="absolute left-4 top-1/2 -translate-y-1/2 pointer-events-none opacity-75">$</span>
                                                        <input type="text" name="amount" class="input !pl-7 mt-2 w-full"
                                                            required min="{{ $bot->min_amount }}"
                                                            max="{{ $bot->max_amount }}" value="{{ old('amount') }}">
                                                    </div>

                                                    @error('amount')
                                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                                    @enderror

                                                    <div class="flex flex-wrap items-center justify-between py-2.5 text-sm">
                                                        <div class="flex items-center px-3">
                                                            <p class="text-md font-semibold">
                                                                Min: ${{ number_format($bot->min_amount, 2) }}
                                                            </p>
                                                        </div>
                                                        <div class="flex items-center px-3">
                                                            <p class="text-md font-semibold">
                                                                Max: ${{ number_format($bot->max_amount, 2) }}
                                                            </p>
                                                        </div>
                                                    </div>

                                                    <div class="mb-4 mt-2 text-sm text-zinc-600 dark:text-zinc-400">
                                                        This bot runs for <strong>{{ $bot->duration_days }}
                                                            days</strong>
                                                        and
                                                        generates approximately
                                                        <strong>{{ $bot->bots_profit }}%</strong> profit daily.
                                                    </div>
                                                </div>
                                            </li>
                                            <li>
                                                <button type="submit"
                                                    class="w-full rounded-md mt-2 h-9 bg-primary text-white flex items-center justify-center gap-2">
                                                    Invest Now
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                        viewBox="0 0 24 24">
                                                        <path fill="currentColor"
                                                            d="M14 9a.5.5 0 0 1 .5-.5H18a.5.5 0 0 1 .5.5v3.5a.5.5 0 0 1-1 0v-2.293l-5.146 5.147a.5.5 0 0 1-.708 0L9 12.707l-2.646 2.647a.5.5 0 0 1-.708-.708l3-3a.5.5 0 0 1 .708 0L12 14.293L16.793 9.5H14.5A.5.5 0 0 1 14 9" />
                                                    </svg>
                                                </button>
                                            </li>
                                        </form>
                                    </ul>
                                </div>
                            </div>
                        @endif --}}
                        <!--:Card:-->
                        <div class="rounded-md border-zinc-200 dark:border-zinc-800 border shadow-card mb-4">
                            <div class="px-4 pt-4 flex items-center gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20"
                                    class="shrink-0">
                                    <g fill="none">
                                        <path fill="url(#SVGWe1wK2Um)"
                                            d="M8.681 2.785c.568-1.047 2.071-1.047 2.638 0l6.5 12.002A1.5 1.5 0 0 1 16.502 17H3.498a1.5 1.5 0 0 1-1.319-2.215z" />
                                        <path fill="url(#SVG5vw1mbOR)" d="M10.5 7.5a.5.5 0 0 0-1 0v4a.5.5 0 0 0 1 0z" />
                                        <path fill="url(#SVGVhFIfcqe)"
                                            d="M10 14.5a.75.75 0 1 0 0-1.5a.75.75 0 0 0 0 1.5" />
                                        <defs>
                                            <linearGradient id="SVGWe1wK2Um" x1="4.497" x2="13.972" y1="-.344"
                                                y2="18.914" gradientUnits="userSpaceOnUse">
                                                <stop stop-color="#ffcd0f" />
                                                <stop offset="1" stop-color="#fe8401" />
                                            </linearGradient>
                                            <linearGradient id="SVG5vw1mbOR" x1="8" x2="11.603" y1="7" y2="14.686"
                                                gradientUnits="userSpaceOnUse">
                                                <stop stop-color="#4a4a4a" />
                                                <stop offset="1" stop-color="#212121" />
                                            </linearGradient>
                                            <linearGradient id="SVGVhFIfcqe" x1="8" x2="11.603" y1="7" y2="14.686"
                                                gradientUnits="userSpaceOnUse">
                                                <stop stop-color="#4a4a4a" />
                                                <stop offset="1" stop-color="#242424" />
                                            </linearGradient>
                                        </defs>
                                    </g>
                                </svg>
                                <h5 class="text-lg font-semibold text-gray-800 dark:text-white">Risk Information
                                </h5>
                            </div>
                            <hr class="border-zinc-200 dark:border-zinc-800 border-dashed my-2">
                            <div class="rounded-xl p-4 shadow-card mb-2">
                                <ul class="ps-4 list-disc flex flex-col gap-2">
                                    <li class="text-muted">
                                        Trading involves substantial risk and may result in loss of capital.
                                    </li>
                                    <li class="text-muted">
                                        Past performance does not guarantee future results.
                                    </li>
                                    <li class="text-muted">
                                        Only invest what you can afford to lose.
                                    </li>
                                    <li class="text-muted">
                                        Bot trading is automated but not guaranteed to be profitable.
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</x-user>
