<x-user :title="$pageTitle">

    <div class="px-1 lg:py-2 rounded-b-md bg-gradient-to-t from-zinc-900 dark:from-zinc-900">
        <div class="rounded-xl shadow-card p-4 sm:p-6 text-center">
            <div class="flex justify-center mb-4">
                <svg xmlns="http://www.w3.org/2000/svg" width="55" height="55" viewBox="0 0 48 48">
                    <g fill="none">
                        <path fill="#deeeff"
                            d="M23.998 47.997c13.255 0 24-10.745 24-24c0-13.254-10.745-24-24-24s-24 10.746-24 24c0 13.255 10.745 24 24 24" />
                        <path fill="#2e3ecd"
                            d="M36.216 14.833a.873.873 0 0 1-.873.873H12.652a.87.87 0 0 1-.873-.873v-1.745c0-.483.39-.873.873-.873h22.69c.483 0 .873.39.873.873z" />
                        <path fill="#2e3ecd" fill-rule="evenodd"
                            d="M17.016 13.524H30.98l3.49 17.455h-2.705l.274-.769l.012-.082a4.85 4.85 0 0 0-9.073-3.02l-2.064 3.87h-7.389z"
                            clip-rule="evenodd" />
                        <path fill="#6bafff" fill-rule="evenodd"
                            d="M31.483 27.01a4.85 4.85 0 0 0-8.505.098l-1.133 2.125h-3.123a2.62 2.62 0 0 0-2.221-2.155l2.26-13.554h10.473z"
                            clip-rule="evenodd" />
                        <path fill="#2e3ecd"
                            d="M23.561 23.997c2.169 0 3.927-1.563 3.927-3.491s-1.758-3.49-3.927-3.49s-3.927 1.562-3.927 3.49s1.758 3.49 3.927 3.49" />
                        <path fill="#6bafff"
                            d="M25.95 20.54c0 .14-.124.252-.282.252h-.076q-.064.39-.261.7a.37.37 0 0 1-.326.174c-.207 0-.365-.145-.365-.329q0-.088.049-.169c.082-.136.147-.27.185-.401h-.827c-.223.735-.56 1.049-1.17 1.049c-.608 0-1-.416-1.076-1.025h-.289c-.157 0-.282-.111-.282-.252c0-.14.125-.25.282-.25h.294a2.25 2.25 0 0 1 .38-.953a.38.38 0 0 1 .327-.164c.212 0 .37.145.37.333c0 .063-.027.13-.07.189c-.147.203-.25.396-.305.619h.865c.212-.696.511-1.04 1.158-1.04c.6 0 1.002.406 1.072 1.015h.065c.158.001.283.112.283.252m-2.714.228h-.756q.058.342.354.343c.18 0 .299-.082.402-.343m.952-.455h.735c-.038-.232-.169-.333-.343-.333c-.169 0-.283.067-.391.333" />
                        <path fill="#2e3ecd" d="m28.35 37.96l2.838-7.965a3.977 3.977 0 0 0-7.44-2.476L18.18 37.96z" />
                        <path fill="#6bafff" d="M29.201 29.98a2.124 2.124 0 0 0-4.015-1.381l-.173.502l4.016 1.38z" />
                    </g>
                </svg>
            </div>
            <h4 class="text-xl lg:text-2xl mb-2">Fund Your Account</h4>
            <p class="mb-6">
                Secure deposits to start trading
            </p>
        </div>
    </div>

    <!--:Page content:-->
    <div class="content flex-grow px-2 lg:px-8 pt-6 mb-4 gap-2.5">
        <div class="px-2 py-4 max-w-7xl mx-auto">
            <div class="grid grid-cols-1 lg:grid-cols-12 mb-4 gap-4">
                <div class="lg:col-span-8">
                    <!--:Project card:-->
                    <div class="rounded-md border-zinc-200 dark:border-zinc-800 border shadow-card p-3 mb-2 relative">
                        <div class="flex items-center gap-3.5">
                            <div class="flex-grow px-2">
                                <h5 class="text-xl">Make A Deposit</h5>
                            </div>
                            <div class="shrink-0">
                                <span class="badge shrink-0 bg-sky-500/10 text-xl text-sky-500">Secured</span>
                            </div>
                        </div>
                        <!--:Description:-->
                        <hr class="border-zinc-200 dark:border-zinc-800 border-dashed my-3">
                        <div class="mb-4 gap-4">
                            <div class="md:col-span-7">
                                <!--:Card:-->
                                <div class="rounded-xl shadow-card mb-4 relative">
                                    <form id="depositForm" action="{{ route('user.deposit.handleConfirm') }}"
                                        method="POST">
                                        @csrf
                                        <div class="p-4">
                                            <div class="flex flex-wrap -mx-2">
                                                <div class="w-full px-2 mt-2 mb-4">
                                                    <label class="mb-1 block">Payment Methods *</label>
                                                    <div class="grid grid-cols-2 md:grid-cols-3 gap-4 mt-4">
                                                        @foreach ($paymentGateways as $gateway)
                                                            <div class="relative">
                                                                <input type="radio" name="payment_gateway_id"
                                                                    id="gateway_{{ $gateway->id }}"
                                                                    value="{{ $gateway->id }}"
                                                                    data-gateway-name="{{ strtolower($gateway->name) }}"
                                                                    class="peer hidden"
                                                                    {{ $loop->first ? 'checked' : '' }}>

                                                                <label for="gateway_{{ $gateway->id }}"
                                                                    class="block p-4 rounded-lg border border-zinc-200 dark:border-zinc-700
                                                                                cursor-pointer transition-all duration-200
                                                                                hover:shadow-md hover:border-primary/60
                                                                                peer-checked:border-primary peer-checked:ring-2 peer-checked:ring-primary/40 peer-checked:bg-primary/5">
                                                                    <div class="flex items-center gap-4">
                                                                        @if ($gateway->logo)
                                                                            <img src="{{ asset('upload/' . $gateway->logo) }}"
                                                                                alt="{{ $gateway->name }}"
                                                                                class="w-10 h-10 object-contain rounded-md border border-gray-200 dark:border-zinc-700">
                                                                        @endif
                                                                        <div>
                                                                            <h3
                                                                                class="text-base font-semibold text-gray-800 dark:text-gray-200">
                                                                                {{ $gateway->name }}
                                                                            </h3>
                                                                            @if ($gateway->currency)
                                                                                <p class="text-sm text-gray-500">
                                                                                    {{ strtoupper($gateway->currency) }}
                                                                                </p>
                                                                            @endif
                                                                            @if ($gateway->rate)
                                                                                <p class="text-sm text-gray-500">
                                                                                    Rate: 1 USD = {{ $gateway->rate }}
                                                                                    {{ strtoupper($gateway->currency) }}
                                                                                </p>
                                                                            @endif
                                                                        </div>
                                                                    </div>
                                                                </label>
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                </div>

                                                <div class="w-full px-2 mt-2 mb-2">
                                                    <label class="mb-1 block">Amount to deposit</label>
                                                    <input type="number" name="amount" id="depositAmount"
                                                        class="input" placeholder="100">
                                                    <x-input-error :messages="$errors->get('amount')" class="mt-2" />
                                                </div>
                                            </div>
                                        </div>
                                        <div class="p-4">
                                            <button type="submit"
                                                class="btn btn-lg bg-blue-500 w-full px-2 text-white hover:bg-primary-deep">
                                                <span
                                                    class="icon-[lucide--upload] text-lg me-1 leading-none text-white"></span>
                                                Proceed with Deposit
                                            </button>
                                        </div>
                                    </form>
                                </div>

                                <script>
                                    document.getElementById('depositForm').addEventListener('submit', function(e) {
                                        e.preventDefault();

                                        const selectedGateway = document.querySelector('input[name="payment_gateway_id"]:checked');
                                        const gatewayName = selectedGateway?.dataset.gatewayName || '';
                                        const amount = document.getElementById('depositAmount').value;

                                        if (!amount || amount <= 0) {
                                            alert('Please enter a valid deposit amount.');
                                            return;
                                        }

                                        // 🔹 If PayPal selected, redirect to PayPal checkout
                                        if (gatewayName.includes('paypal')) {
                                            const checkoutUrl = "{{ route('paypal.checkout') }}";
                                            window.location.href = checkoutUrl + '?amount=' + encodeURIComponent(amount);
                                            return;
                                        }

                                        // 🔹 Otherwise, submit the manual deposit form normally
                                        e.target.submit();
                                    });
                                </script>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="lg:col-span-4">
                    <!--:Tasks:-->
                    <div class="divide-dashed divide-y divide-zinc-500/10 dark:divide-zinc-800 overflow-hidden rounded-md border-zinc-200 dark:border-zinc-800 border shadow-card mb-4"
                        id="task-board">
                        <!-- Parent Task -->
                        <div class="mb-2 pb-2 parent-task group">
                            <div class="flex items-center justify-between px-4 pt-4 pb-2.5">
                                <div class="flex items-center">
                                    <h5 class="text-lg">Deposit Gateways</h5>
                                </div>
                            </div>

                            <!-- Child Tasks List -->
                            <ul
                                class="divide-y px-4 whitespace-nowrap overflow-x-auto divide-zinc-500/10 dark:divide-zinc-800 child-list">
                                @foreach ($paymentGateways as $gateway)
                                    <li class="flex items-start py-2.5 child-task min-w-max">

                                        <!--:Drag handler:-->
                                        <span class="drag-handle shrink-0 cursor-grab text-zinc-500 dark:text-zinc-400">
                                            <img src="{{ asset('upload/' . $gateway->logo) }}"
                                                style="height:18px; width:18px;">
                                        </span>
                                        <!--:Task desc:-->
                                        <div class="flex items-center flex-grow px-3">
                                            <label for="task1"
                                                class="peer-checked:line-through peer-checked:opacity-50">
                                                {{ $gateway->name }}
                                            </label>
                                        </div>
                                        <!--:Date/priority/status:-->
                                        <div class="flex items-center space-x-2 text-sm shrink-0">
                                            <span
                                                class="badge bg-sky-500/10 text-sky-500">{{ $gateway->currency }}</span>
                                        </div>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                    <!--:Card:-->
                    <div class="rounded-md bg-white dark:bg-zinc-900 shadow-card mb-4">
                        <div class="px-4 pt-4 flex items-center justify-between">
                            <h5 class="text-lg">How to make Deposit</h5>
                        </div>
                        <!--:Team list:-->
                        <ul class="px-4 py-1 divide-y flex flex-col divide-zinc-500/10 dark:divide-zinc-800">
                            <li class="flex items-center gap-3.5 py-3">
                                <div
                                    class="items-center justify-center mb-1 size-6 flex rounded-full shrink-0 bg-primary">
                                    1
                                </div>
                                <div class="flex-grow">
                                    <h6 class="truncate">Choose a payment method</h6>
                                </div>
                            </li>
                            <li class="flex items-center gap-3.5 py-3">
                                <div
                                    class="items-center justify-center mb-1 size-6 flex rounded-full shrink-0 bg-amber-500">
                                    2
                                </div>
                                <div class="flex-grow">
                                    <h6 class="truncate">Enter Deposit Amount</h6>
                                </div>
                            </li>
                            <li class="flex items-center gap-3.5 py-3">
                                <div
                                    class="items-center justify-center mb-1 size-6 flex rounded-full shrink-0 bg-primary/20">
                                    3
                                </div>
                                <div class="flex-grow">
                                    <h6 class="truncate">Complete Secured Payment</h6>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

</x-user>
